/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.ingester;

import com.google.common.base.Function;
import com.wavefront.common.TaggedMetricName;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.MetricName;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public abstract class Ingester
implements Runnable {
    private static final Logger logger = Logger.getLogger(Ingester.class.getCanonicalName());
    private static final int CHANNEL_IDLE_TIMEOUT_IN_SECS_DEFAULT = (int)TimeUnit.DAYS.toSeconds(1L);
    protected final int listeningPort;
    protected ChannelInitializer initializer;
    private Counter connectionsAccepted;
    private Counter connectionsIdleClosed;
    @Nullable
    protected Map<ChannelOption<?>, ?> parentChannelOptions;
    @Nullable
    protected Map<ChannelOption<?>, ?> childChannelOptions;

    @Deprecated
    public Ingester(@Nullable List<Function<Channel, ChannelHandler>> decoders, ChannelHandler commandHandler, int port) {
        this.listeningPort = port;
        this.createInitializer(decoders, commandHandler);
        this.initMetrics(port);
    }

    @Deprecated
    public Ingester(ChannelHandler commandHandler, int port) {
        this.listeningPort = port;
        this.createInitializer(null, commandHandler);
        this.initMetrics(port);
    }

    public Ingester(ChannelInitializer initializer, int port) {
        this.listeningPort = port;
        this.initializer = initializer;
        this.initMetrics(port);
    }

    public Ingester withParentChannelOptions(Map<ChannelOption<?>, ?> parentChannelOptions) {
        this.parentChannelOptions = parentChannelOptions;
        return this;
    }

    public Ingester withChildChannelOptions(Map<ChannelOption<?>, ?> childChannelOptions) {
        this.childChannelOptions = childChannelOptions;
        return this;
    }

    private void initMetrics(int port) {
        this.connectionsAccepted = Metrics.newCounter((MetricName)new TaggedMetricName("listeners", "connections.accepted", "port", String.valueOf(port)));
        this.connectionsIdleClosed = Metrics.newCounter((MetricName)new TaggedMetricName("listeners", "connections.idle.closed", "port", String.valueOf(port)));
    }

    private void createInitializer(final @Nullable List<Function<Channel, ChannelHandler>> decoders, final ChannelHandler commandHandler) {
        this.initializer = new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                Ingester.this.connectionsAccepted.inc();
                ChannelPipeline pipeline = ch.pipeline();
                Ingester.this.addDecoders((Channel)ch, decoders);
                Ingester.this.addIdleTimeoutHandler(pipeline);
                pipeline.addLast(new ChannelHandler[]{commandHandler});
            }
        };
    }

    protected void addIdleTimeoutHandler(ChannelPipeline pipeline) {
        pipeline.addLast("idleStateHandler", (ChannelHandler)new IdleStateHandler(CHANNEL_IDLE_TIMEOUT_IN_SECS_DEFAULT, 0, 0));
        pipeline.addLast("idleChannelTerminator", (ChannelHandler)new ChannelDuplexHandler(){

            public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                if (evt instanceof IdleStateEvent && ((IdleStateEvent)evt).state() == IdleState.READER_IDLE) {
                    Ingester.this.connectionsIdleClosed.inc();
                    logger.warning("Closing idle connection, client inactivity timeout expired: " + ctx.channel());
                    ctx.close();
                }
            }
        });
    }

    protected void addDecoders(Channel ch, @Nullable List<Function<Channel, ChannelHandler>> decoders) {
        if (decoders != null) {
            ChannelPipeline pipeline = ch.pipeline();
            for (Function<Channel, ChannelHandler> handler : decoders) {
                pipeline.addLast(new ChannelHandler[]{(ChannelHandler)handler.apply((Object)ch)});
            }
        }
    }
}

