/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.ingester;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.wavefront.ingester.AbstractIngesterFormatter;
import com.wavefront.ingester.IngesterContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import wavefront.report.Annotation;
import wavefront.report.ReportLog;

public class ReportLogIngesterFormatter
extends AbstractIngesterFormatter<ReportLog> {
    private ReportLogIngesterFormatter(List<AbstractIngesterFormatter.FormatterElement<ReportLog>> elements) {
        super(elements);
    }

    public static AbstractIngesterFormatter.IngesterFormatBuilder<ReportLog> newBuilder() {
        return new ReportLogIngesterFormatBuilder();
    }

    @Override
    public ReportLog drive(String logJson, @Nullable Supplier<String> defaultHostNameSupplier, String customerId, @Nullable List<String> customSourceTags, @Nullable List<String> customLogTimestampTags, @Nullable List<String> customLogMessageTags, List<String> customLogApplicationTags, List<String> customLogServiceTags, @Nullable IngesterContext ingesterContext) {
        ReportLog log = new ReportLog();
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        try {
            Map tagMap = (Map)new ObjectMapper().readValue(logJson, (TypeReference)new TypeReference<Map<String, Object>>(){});
            for (Map.Entry tagKV : tagMap.entrySet()) {
                String tagK = (String)tagKV.getKey();
                String tagV = tagKV.getValue() == null ? "null" : tagKV.getValue().toString();
                annotations.add(Annotation.newBuilder().setKey(tagK).setValue(tagV).build());
            }
            log.setAnnotations(annotations);
            String host = AbstractIngesterFormatter.getHost(log.getAnnotations(), customSourceTags);
            if (host == null) {
                host = defaultHostNameSupplier == null ? "unknown" : defaultHostNameSupplier.get();
            }
            log.setHost(host);
            Long timestamp = AbstractIngesterFormatter.getLogTimestamp(log.getAnnotations(), customLogTimestampTags);
            log.setTimestamp(timestamp);
            String message = AbstractIngesterFormatter.getLogMessage(log.getAnnotations(), customLogMessageTags);
            log.setMessage(message);
            String application = AbstractIngesterFormatter.getLogApplication(log.getAnnotations(), customLogApplicationTags);
            log.setApplication(application);
            String service = AbstractIngesterFormatter.getLogService(log.getAnnotations(), customLogServiceTags);
            log.setService(service);
            return log;
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static class ReportLogIngesterFormatBuilder
    extends AbstractIngesterFormatter.IngesterFormatBuilder<ReportLog> {
        public ReportLogIngesterFormatter build() {
            return new ReportLogIngesterFormatter(this.elements);
        }
    }
}

