/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.predicates;

import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import com.wavefront.common.TimeProvider;
import com.wavefront.ingester.AbstractIngesterFormatter;
import com.wavefront.predicates.BaseExpression;
import com.wavefront.predicates.ExpressionSyntaxException;
import com.wavefront.predicates.MathExpression;
import com.wavefront.predicates.MultiStringComparisonExpression;
import com.wavefront.predicates.PredicateEvalExpression;
import com.wavefront.predicates.PredicateMatchOp;
import com.wavefront.predicates.StringComparisonExpression;
import com.wavefront.predicates.StringExpression;
import com.wavefront.predicates.TemplateStringExpression;
import com.wavefront.predicates.Util;
import condition.parser.PredicateExpressionBaseVisitor;
import condition.parser.PredicateExpressionParser;
import java.util.List;
import java.util.Random;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.RuleNode;
import org.apache.commons.lang.StringUtils;
import wavefront.report.ReportHistogram;
import wavefront.report.ReportMetric;
import wavefront.report.ReportPoint;
import wavefront.report.Span;

public class PredicateExpressionVisitorImpl
extends PredicateExpressionBaseVisitor<BaseExpression> {
    private static final Random RANDOM = new Random();
    private final TimeProvider timeProvider;

    public PredicateExpressionVisitorImpl(TimeProvider timeProvider) {
        this.timeProvider = timeProvider;
    }

    @Override
    public BaseExpression visitEvalExpression(PredicateExpressionParser.EvalExpressionContext ctx) {
        if (ctx == null) {
            throw new ExpressionSyntaxException("Syntax error");
        }
        if (ctx.ternary != null) {
            return this.iff(this.eval(ctx.evalExpression(0)), this.eval(ctx.evalExpression(1)), this.eval(ctx.evalExpression(2)));
        }
        if (ctx.op != null) {
            return new MathExpression(this.eval(ctx.evalExpression(0)), this.eval(ctx.evalExpression(1)), ctx.op.getText().toLowerCase().replace(" ", ""));
        }
        if (ctx.comparisonOperator() != null) {
            return new MathExpression(this.eval(ctx.evalExpression(0)), this.eval(ctx.evalExpression(1)), ctx.comparisonOperator().getText().replace(" ", ""));
        }
        if (ctx.not != null) {
            PredicateEvalExpression expression = this.eval(ctx.evalExpression(0));
            return entity -> PredicateEvalExpression.asDouble(!PredicateEvalExpression.isTrue(expression.getValue(entity)));
        }
        if (ctx.complement != null) {
            PredicateEvalExpression expression = this.eval(ctx.evalExpression(0));
            return entity -> (long)expression.getValue(entity) ^ 0xFFFFFFFFFFFFFFFFL;
        }
        if (ctx.multiModifier != null) {
            String scope = AbstractIngesterFormatter.unquote(ctx.placeholder().tagk().getText());
            StringExpression argument = this.stringExpression(ctx.stringExpression(0));
            String op = ctx.stringComparisonOp().getText();
            return MultiStringComparisonExpression.of(scope, argument, PredicateMatchOp.fromString(ctx.multiModifier.getText()), op);
        }
        if (ctx.stringComparisonOp() != null) {
            StringExpression left = this.stringExpression(ctx.stringExpression(0));
            StringExpression right = this.stringExpression(ctx.stringExpression(1));
            return StringComparisonExpression.of(left, right, ctx.stringComparisonOp().getText());
        }
        if (ctx.in != null && ctx.stringExpression().size() > 1) {
            StringExpression left = this.stringExpression(ctx.stringExpression(0));
            List branches = ctx.stringExpression().subList(1, ctx.stringExpression().size()).stream().map(exp -> StringComparisonExpression.of(left, this.stringExpression((PredicateExpressionParser.StringExpressionContext)((Object)exp)), "=")).collect(Collectors.toList());
            return entity -> PredicateEvalExpression.asDouble(branches.stream().anyMatch(x -> PredicateEvalExpression.isTrue(x.getValue(entity))));
        }
        if (ctx.stringEvalFunc() != null) {
            StringExpression input = this.stringExpression(ctx.stringExpression(0));
            if (ctx.stringEvalFunc().strLength() != null) {
                return entity -> input.getString(entity).length();
            }
            if (ctx.stringEvalFunc().strHashCode() != null) {
                return entity -> Hashing.murmur3_32().hashString((CharSequence)input.getString(entity), Charsets.UTF_8).asInt();
            }
            if (ctx.stringEvalFunc().strIsEmpty() != null) {
                return entity -> PredicateEvalExpression.asDouble(StringUtils.isEmpty((String)input.getString(entity)));
            }
            if (ctx.stringEvalFunc().strIsNotEmpty() != null) {
                return entity -> PredicateEvalExpression.asDouble(StringUtils.isNotEmpty((String)input.getString(entity)));
            }
            if (ctx.stringEvalFunc().strIsBlank() != null) {
                return entity -> PredicateEvalExpression.asDouble(StringUtils.isBlank((String)input.getString(entity)));
            }
            if (ctx.stringEvalFunc().strIsNotBlank() != null) {
                return entity -> PredicateEvalExpression.asDouble(StringUtils.isNotBlank((String)input.getString(entity)));
            }
            if (ctx.stringEvalFunc().strParse() != null) {
                PredicateEvalExpression def = ctx.stringEvalFunc().strParse().evalExpression() == null ? x -> 0.0 : this.eval(ctx.stringEvalFunc().strParse().evalExpression());
                return entity -> {
                    try {
                        return Double.parseDouble(input.getString(entity));
                    }
                    catch (NumberFormatException e) {
                        return def.getValue(entity);
                    }
                };
            }
            throw new ExpressionSyntaxException("Unknown string eval function");
        }
        if (ctx.propertyAccessor() != null) {
            return this.getPropertyAccessor(ctx.propertyAccessor().getText());
        }
        if (ctx.number() != null) {
            return entity -> PredicateExpressionVisitorImpl.getNumber(ctx.number());
        }
        if (ctx.evalExpression(0) != null) {
            return this.eval(ctx.evalExpression(0));
        }
        return (BaseExpression)this.visitChildren((RuleNode)ctx);
    }

    @Override
    public BaseExpression visitStringExpression(PredicateExpressionParser.StringExpressionContext ctx) {
        if (ctx.concat != null) {
            StringExpression left = this.stringExpression(ctx.stringExpression(0));
            StringExpression right = this.stringExpression(ctx.stringExpression(1));
            return entity -> left.getString(entity) + right.getString(entity);
        }
        if (ctx.stringFunc() != null) {
            StringExpression input = this.stringExpression(ctx.stringExpression(0));
            if (ctx.stringFunc().strReplace() != null) {
                StringExpression search = this.stringExpression(ctx.stringFunc().strReplace().stringExpression(0));
                StringExpression replacement = this.stringExpression(ctx.stringFunc().strReplace().stringExpression(1));
                return entity -> input.getString(entity).replace(search.getString(entity), replacement.getString(entity));
            }
            if (ctx.stringFunc().strReplaceAll() != null) {
                StringExpression regex = this.stringExpression(ctx.stringFunc().strReplaceAll().stringExpression(0));
                StringExpression replacement = this.stringExpression(ctx.stringFunc().strReplaceAll().stringExpression(1));
                return entity -> input.getString(entity).replaceAll(regex.getString(entity), replacement.getString(entity));
            }
            if (ctx.stringFunc().strSubstring() != null) {
                PredicateEvalExpression fromExp = this.eval(ctx.stringFunc().strSubstring().evalExpression(0));
                if (ctx.stringFunc().strSubstring().evalExpression().size() > 1) {
                    PredicateEvalExpression toExp = this.eval(ctx.stringFunc().strSubstring().evalExpression(1));
                    return entity -> input.getString(entity).substring((int)fromExp.getValue(entity), (int)toExp.getValue(entity));
                }
                return entity -> input.getString(entity).substring((int)fromExp.getValue(entity));
            }
            if (ctx.stringFunc().strLeft() != null) {
                PredicateEvalExpression index = this.eval(ctx.stringFunc().strLeft().evalExpression());
                return entity -> input.getString(entity).substring(0, (int)index.getValue(entity));
            }
            if (ctx.stringFunc().strRight() != null) {
                PredicateEvalExpression index = this.eval(ctx.stringFunc().strRight().evalExpression());
                return entity -> {
                    String str = input.getString(entity);
                    return str.substring(str.length() - (int)index.getValue(entity));
                };
            }
            if (ctx.stringFunc().strToLowerCase() != null) {
                return entity -> input.getString(entity).toLowerCase();
            }
            if (ctx.stringFunc().strToUpperCase() != null) {
                return entity -> input.getString(entity).toUpperCase();
            }
            throw new ExpressionSyntaxException("Unknown string function");
        }
        if (ctx.asString() != null) {
            return this.visitAsString(ctx.asString());
        }
        if (ctx.string() != null) {
            String text = ctx.string().getText();
            return new TemplateStringExpression(ctx.string().Quoted() != null ? AbstractIngesterFormatter.unquote(text) : text);
        }
        if (ctx.stringExpression(0) != null) {
            return this.visitStringExpression(ctx.stringExpression(0));
        }
        return (BaseExpression)this.visitChildren((RuleNode)ctx);
    }

    @Override
    public BaseExpression visitIff(PredicateExpressionParser.IffContext ctx) {
        if (ctx == null) {
            throw new ExpressionSyntaxException("Syntax error for if()");
        }
        return this.iff(this.eval(ctx.evalExpression(0)), this.eval(ctx.evalExpression(1)), this.eval(ctx.evalExpression(2)));
    }

    @Override
    public BaseExpression visitParse(PredicateExpressionParser.ParseContext ctx) {
        StringExpression strExp = this.stringExpression(ctx.stringExpression());
        PredicateEvalExpression defaultExp = ctx.evalExpression() == null ? x -> 0.0 : this.eval(ctx.evalExpression());
        return entity -> {
            try {
                return Double.parseDouble(strExp.getString(entity));
            }
            catch (NumberFormatException e) {
                return defaultExp.getValue(entity);
            }
        };
    }

    @Override
    public BaseExpression visitTime(PredicateExpressionParser.TimeContext ctx) {
        TimeZone tz;
        if (ctx.stringExpression(0) == null) {
            throw new ExpressionSyntaxException("Cannot parse time argument");
        }
        StringExpression timeExp = this.stringExpression(ctx.stringExpression(0));
        if (ctx.stringExpression().size() == 1) {
            tz = TimeZone.getTimeZone("UTC");
        } else {
            StringExpression tzExp = this.stringExpression(ctx.stringExpression(1));
            tz = TimeZone.getTimeZone(tzExp.getString(null));
        }
        String testString = timeExp.getString(null);
        try {
            Util.parseTextualTimeExact(testString, this.timeProvider.currentTimeMillis(), tz);
        }
        catch (IllegalArgumentException e) {
            throw new ExpressionSyntaxException("Cannot parse '" + testString + "' as time!");
        }
        return entity -> Util.parseTextualTimeExact(timeExp.getString(entity), this.timeProvider.currentTimeMillis(), tz);
    }

    @Override
    public BaseExpression visitEvalLength(PredicateExpressionParser.EvalLengthContext ctx) {
        StringExpression exp = this.stringExpression(ctx.stringExpression());
        return entity -> exp.getString(entity).length();
    }

    @Override
    public BaseExpression visitEvalHashCode(PredicateExpressionParser.EvalHashCodeContext ctx) {
        StringExpression exp = this.stringExpression(ctx.stringExpression());
        return entity -> Hashing.murmur3_32().hashString((CharSequence)exp.getString(entity), Charsets.UTF_8).asInt();
    }

    @Override
    public BaseExpression visitEvalIsEmpty(PredicateExpressionParser.EvalIsEmptyContext ctx) {
        StringExpression exp = this.stringExpression(ctx.stringExpression());
        return entity -> PredicateEvalExpression.asDouble(StringUtils.isEmpty((String)exp.getString(entity)));
    }

    @Override
    public BaseExpression visitEvalIsNotEmpty(PredicateExpressionParser.EvalIsNotEmptyContext ctx) {
        StringExpression exp = this.stringExpression(ctx.stringExpression());
        return entity -> PredicateEvalExpression.asDouble(StringUtils.isNotEmpty((String)exp.getString(entity)));
    }

    @Override
    public BaseExpression visitEvalIsBlank(PredicateExpressionParser.EvalIsBlankContext ctx) {
        StringExpression exp = this.stringExpression(ctx.stringExpression());
        return entity -> PredicateEvalExpression.asDouble(StringUtils.isBlank((String)exp.getString(entity)));
    }

    @Override
    public BaseExpression visitEvalIsNotBlank(PredicateExpressionParser.EvalIsNotBlankContext ctx) {
        StringExpression exp = this.stringExpression(ctx.stringExpression());
        return entity -> PredicateEvalExpression.asDouble(StringUtils.isNotBlank((String)exp.getString(entity)));
    }

    @Override
    public BaseExpression visitRandom(PredicateExpressionParser.RandomContext ctx) {
        return entity -> RANDOM.nextDouble();
    }

    @Override
    public BaseExpression visitAsString(PredicateExpressionParser.AsStringContext ctx) {
        PredicateEvalExpression valueExpression = this.eval(ctx.evalExpression());
        if (ctx.stringExpression() == null) {
            return entity -> String.valueOf(valueExpression.getValue(entity));
        }
        StringExpression format = this.stringExpression(ctx.stringExpression());
        return entity -> String.format(format.getString(entity), valueExpression.getValue(entity));
    }

    @Override
    public BaseExpression visitStrIff(PredicateExpressionParser.StrIffContext ctx) {
        if (ctx == null) {
            throw new ExpressionSyntaxException("Syntax error for if()");
        }
        PredicateEvalExpression condition = this.eval(ctx.evalExpression());
        StringExpression thenExpression = this.stringExpression(ctx.stringExpression(0));
        StringExpression elseExpression = this.stringExpression(ctx.stringExpression(1));
        return entity -> PredicateEvalExpression.isTrue(condition.getValue(entity)) ? thenExpression.getString(entity) : elseExpression.getString(entity);
    }

    private PredicateEvalExpression eval(PredicateExpressionParser.EvalExpressionContext ctx) {
        return (PredicateEvalExpression)this.visitEvalExpression(ctx);
    }

    private StringExpression stringExpression(PredicateExpressionParser.StringExpressionContext ctx) {
        return (StringExpression)this.visitStringExpression(ctx);
    }

    private PredicateEvalExpression iff(PredicateEvalExpression cond, PredicateEvalExpression thenExp, PredicateEvalExpression elseExp) {
        return x -> PredicateEvalExpression.isTrue(cond.getValue(x)) ? thenExp.getValue(x) : elseExp.getValue(x);
    }

    private PredicateEvalExpression getPropertyAccessor(String property) {
        switch (property) {
            case "value": {
                return entity -> {
                    if (entity instanceof ReportMetric) {
                        return ((ReportMetric)((Object)((Object)entity))).getValue();
                    }
                    if (entity instanceof ReportPoint) {
                        return ((ReportPoint)((Object)((Object)entity))).getValue() instanceof Number ? ((Number)((ReportPoint)((Object)((Object)entity))).getValue()).doubleValue() : 0.0;
                    }
                    throw new IllegalArgumentException("$value can only be used on a metric, got " + entity.getClass().getCanonicalName());
                };
            }
            case "timestamp": {
                return entity -> {
                    if (entity instanceof ReportMetric) {
                        return ((ReportMetric)((Object)((Object)entity))).getTimestamp();
                    }
                    if (entity instanceof ReportHistogram) {
                        return ((ReportHistogram)((Object)((Object)entity))).getTimestamp();
                    }
                    if (entity instanceof ReportPoint) {
                        return ((ReportPoint)((Object)((Object)entity))).getTimestamp();
                    }
                    throw new IllegalArgumentException("$timestamp can only be used on a metric or a histogram, got " + entity.getClass().getCanonicalName());
                };
            }
            case "startMillis": {
                return entity -> {
                    if (entity instanceof Span) {
                        return ((Span)((Object)((Object)entity))).getStartMillis();
                    }
                    throw new IllegalArgumentException("$startMillis can only be used on a Span, got " + entity.getClass().getCanonicalName());
                };
            }
            case "duration": {
                return entity -> {
                    if (entity instanceof Span) {
                        return ((Span)((Object)((Object)entity))).getDuration();
                    }
                    throw new IllegalArgumentException("$duration can only be used on a Span, got " + entity.getClass().getCanonicalName());
                };
            }
        }
        throw new ExpressionSyntaxException("Unknown property: " + property);
    }

    private static double getNumber(PredicateExpressionParser.NumberContext numberContext) {
        double toReturn;
        if (numberContext == null || numberContext.Number() == null) {
            throw new ExpressionSyntaxException("Cannot parse number");
        }
        String text = numberContext.Number().getText();
        double d = toReturn = text.startsWith("0x") ? (double)Long.decode(text).longValue() : Double.parseDouble(text);
        if (numberContext.MinusSign() != null) {
            toReturn = -toReturn;
        }
        if (numberContext.siSuffix() != null) {
            String suffix;
            switch (suffix = numberContext.siSuffix().getText()) {
                case "Y": {
                    toReturn *= 1.0E24;
                    break;
                }
                case "Z": {
                    toReturn *= 1.0E21;
                    break;
                }
                case "E": {
                    toReturn *= 1.0E18;
                    break;
                }
                case "P": {
                    toReturn *= 1.0E15;
                    break;
                }
                case "T": {
                    toReturn *= 1.0E12;
                    break;
                }
                case "G": {
                    toReturn *= 1.0E9;
                    break;
                }
                case "M": {
                    toReturn *= 1000000.0;
                    break;
                }
                case "k": {
                    toReturn *= 1000.0;
                    break;
                }
                case "h": {
                    toReturn *= 100.0;
                    break;
                }
                case "da": {
                    toReturn *= 10.0;
                    break;
                }
                case "d": {
                    toReturn *= 0.1;
                    break;
                }
                case "c": {
                    toReturn *= 0.01;
                    break;
                }
                case "m": {
                    toReturn *= 0.001;
                    break;
                }
                case "\u00b5": {
                    toReturn *= 1.0E-6;
                    break;
                }
                case "n": {
                    toReturn *= 1.0E-9;
                    break;
                }
                case "p": {
                    toReturn *= 1.0E-12;
                    break;
                }
                case "f": {
                    toReturn *= 1.0E-15;
                    break;
                }
                case "a": {
                    toReturn *= 1.0E-18;
                    break;
                }
                case "z": {
                    toReturn *= 1.0E-21;
                    break;
                }
                case "y": {
                    toReturn *= 1.0E-24;
                    break;
                }
                default: {
                    throw new ExpressionSyntaxException("Unknown SI Suffix: " + suffix);
                }
            }
        }
        return toReturn;
    }
}

