/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.dto;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.wavefront.common.SerializerUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import wavefront.report.Annotation;
import wavefront.report.ReportLog;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Log
implements Serializable {
    @JsonProperty(value="timestamp")
    private long timestamp;
    @JsonProperty(value="text")
    private String message;
    @JsonProperty
    private String source;
    @JsonProperty(value="application")
    private String application;
    @JsonProperty(value="service")
    private String service;
    @JsonProperty(value="log_level")
    private String level;
    @JsonProperty(value="error_name")
    private String exception;
    private Map<String, String> annotations;
    @JsonIgnore
    private int dataSize;

    private Log() {
    }

    public Log(ReportLog log) {
        this.timestamp = log.getTimestamp();
        this.message = log.getMessage();
        this.source = log.getHost();
        this.application = log.getApplication();
        this.service = log.getService();
        this.level = log.getLevel();
        this.exception = log.getException();
        this.annotations = new HashMap<String, String>();
        for (Annotation tag : log.getAnnotations()) {
            this.annotations.put(tag.getKey(), tag.getValue());
        }
        this.dataSize = this.toString().length();
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getMessage() {
        return this.message;
    }

    public String getApplication() {
        return this.application;
    }

    public String getService() {
        return this.service;
    }

    public String getSource() {
        return this.source;
    }

    public int getDataSize() {
        return this.dataSize;
    }

    public String getLevel() {
        return this.level;
    }

    public String getException() {
        return this.exception;
    }

    @JsonAnyGetter
    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (int)(this.timestamp ^ this.timestamp >>> 32);
        result = result * 31 + (this.message == null ? 0 : this.message.hashCode());
        result = result * 31 + (this.source == null ? 0 : this.source.hashCode());
        result = result * 31 + (this.application == null ? 0 : this.application.hashCode());
        result = result * 31 + (this.service == null ? 0 : this.service.hashCode());
        result = result * 31 + (this.level == null ? 0 : this.level.hashCode());
        result = result * 31 + (this.exception == null ? 0 : this.exception.hashCode());
        result = result * 31 + this.annotations.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Log other = (Log)obj;
        if (this.timestamp != other.timestamp) {
            return false;
        }
        if (!Objects.equals(this.message, other.message)) {
            return false;
        }
        if (!Objects.equals(this.application, other.application)) {
            return false;
        }
        if (!Objects.equals(this.service, other.service)) {
            return false;
        }
        if (!Objects.equals(this.source, other.source)) {
            return false;
        }
        if (!Objects.equals(this.level, other.level)) {
            return false;
        }
        if (!Objects.equals(this.exception, other.exception)) {
            return false;
        }
        return this.annotations.equals(other.annotations);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        for (String key : this.annotations.keySet()) {
            SerializerUtils.appendQuoted(sb, key);
            sb.append(":");
            SerializerUtils.appendQuoted(sb, this.annotations.get(key));
            sb.append(", ");
        }
        SerializerUtils.appendQuoted(sb, "timestamp");
        sb.append(":");
        sb.append(this.timestamp);
        sb.append(", ");
        SerializerUtils.appendQuoted(sb, "text");
        sb.append(":");
        SerializerUtils.appendQuoted(sb, this.message);
        sb.append(", ");
        SerializerUtils.appendQuoted(sb, "source");
        sb.append(":");
        SerializerUtils.appendQuoted(sb, this.source);
        sb.append(", ");
        SerializerUtils.appendQuoted(sb, "application");
        sb.append(":");
        SerializerUtils.appendQuoted(sb, this.application);
        sb.append(", ");
        SerializerUtils.appendQuoted(sb, "service");
        sb.append(":");
        SerializerUtils.appendQuoted(sb, this.service);
        sb.append(", ");
        SerializerUtils.appendQuoted(sb, "log_level");
        sb.append(":");
        SerializerUtils.appendQuoted(sb, this.level);
        sb.append(", ");
        SerializerUtils.appendQuoted(sb, "error_name");
        sb.append(":");
        SerializerUtils.appendQuoted(sb, this.exception);
        sb.append("}");
        return sb.toString();
    }
}

