/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.ingester;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.wavefront.common.Clock;
import com.wavefront.data.ParseException;
import com.wavefront.ingester.IngesterContext;
import com.wavefront.ingester.StringParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.commons.lang.StringUtils;
import wavefront.report.Annotation;
import wavefront.report.Histogram;

public abstract class AbstractIngesterFormatter<T extends SpecificRecordBase> {
    public static final String SOURCE_TAG_LITERAL = "@SourceTag";
    public static final String SOURCE_DESCRIPTION_LITERAL = "@SourceDescription";
    public static final String EVENT_LITERAL = "@Event";
    private static final String SINGLE_QUOTE_STR = "'";
    private static final String ESCAPED_SINGLE_QUOTE_STR = "\\'";
    private static final String DOUBLE_QUOTE_STR = "\"";
    private static final String ESCAPED_DOUBLE_QUOTE_STR = "\\\"";
    private static final List<String> DEFAULT_LOG_MESSAGE_KEYS = Arrays.asList("message", "text");
    private static final List<String> DEFAULT_LOG_TIMESTAMP_KEYS = Arrays.asList("timestamp", "log_timestamp");
    private static final List<String> DEFAULT_LOG_APPLICATION_KEYS = Collections.singletonList("application");
    private static final List<String> DEFAULT_LOG_SERVICE_KEYS = Collections.singletonList("service");
    private static final List<String> DEFAULT_LOG_EXCEPTION_KEYS = Arrays.asList("exception", "error_name");
    private static final List<String> DEFAULT_LOG_LEVEL_KEYS = Arrays.asList("level", "log_level");
    protected final List<FormatterElement<T>> elements;

    protected AbstractIngesterFormatter(List<FormatterElement<T>> elements) {
        this.elements = elements;
    }

    public static long timestampInMilliseconds(Double timestamp) {
        long timestampLong = timestamp.longValue();
        if (timestampLong < 1000000000000L) {
            return (long)(1000.0 * timestamp);
        }
        if (timestampLong < 10000000000000L) {
            return timestampLong;
        }
        if (timestampLong < 10000000000000000L) {
            return timestampLong / 1000L;
        }
        return timestampLong / 1000000L;
    }

    private static Long parseTimestamp(StringParser parser, boolean optional, boolean raw) {
        String peek = parser.peek();
        if (peek == null || !Character.isDigit(peek.charAt(0))) {
            if (optional) {
                return null;
            }
            throw new ParseException("Expected timestamp, found " + (peek == null ? "end of line" : peek));
        }
        try {
            Double timestamp = Double.parseDouble(peek);
            parser.next();
            if (raw) {
                return timestamp.longValue();
            }
            return AbstractIngesterFormatter.timestampInMilliseconds(timestamp);
        }
        catch (NumberFormatException nfe) {
            throw new ParseException("Invalid timestamp value: " + peek);
        }
    }

    private static void parseKeyValuePair(StringParser parser, BiConsumer<String, String> kvConsumer) {
        String annotationKey = parser.next();
        String op = parser.next();
        if (op == null) {
            throw new ParseException("Tag keys and values must be separated by '=', nothing found after '" + annotationKey + SINGLE_QUOTE_STR);
        }
        if (!op.equals("=")) {
            throw new ParseException("Tag keys and values must be separated by '=', found " + op);
        }
        String annotationValue = parser.next();
        if (annotationValue == null) {
            throw new ParseException("Value missing for " + annotationKey);
        }
        kvConsumer.accept(annotationKey, annotationValue);
    }

    public static String unquote(String text) {
        if (text.startsWith(DOUBLE_QUOTE_STR)) {
            String quoteless = text.substring(1, text.length() - 1);
            if (StringUtils.containsAny((String)quoteless, (String)ESCAPED_DOUBLE_QUOTE_STR)) {
                return StringUtils.replace((String)quoteless, (String)ESCAPED_DOUBLE_QUOTE_STR, (String)DOUBLE_QUOTE_STR);
            }
            return quoteless;
        }
        if (text.startsWith(SINGLE_QUOTE_STR)) {
            String quoteless = text.substring(1, text.length() - 1);
            if (StringUtils.containsAny((String)quoteless, (String)ESCAPED_SINGLE_QUOTE_STR)) {
                return StringUtils.replace((String)quoteless, (String)ESCAPED_SINGLE_QUOTE_STR, (String)SINGLE_QUOTE_STR);
            }
            return quoteless;
        }
        return text;
    }

    @Nullable
    public static String getHost(@Nullable List<Annotation> annotations, @Nullable List<String> customSourceTags) {
        String source = null;
        String host = null;
        if (annotations != null) {
            Iterator<Annotation> iter = annotations.iterator();
            while (iter.hasNext()) {
                Annotation annotation = iter.next();
                if (annotation.getKey().equals("source")) {
                    iter.remove();
                    source = annotation.getValue();
                    continue;
                }
                if (annotation.getKey().equals("host")) {
                    iter.remove();
                    host = annotation.getValue();
                    continue;
                }
                if (!annotation.getKey().equals("tag")) continue;
                annotation.setKey("_tag");
            }
            if (host != null) {
                if (source == null) {
                    source = host;
                } else {
                    annotations.add(new Annotation("_host", host));
                }
            }
            if (source == null && customSourceTags != null) {
                for (String tag : customSourceTags) {
                    for (Annotation annotation : annotations) {
                        if (!annotation.getKey().equals(tag)) continue;
                        source = annotation.getValue();
                        break;
                    }
                    if (source == null) continue;
                    break;
                }
            }
        }
        return source;
    }

    @Nullable
    public static String getLogMessage(@Nullable List<Annotation> annotations, @Nullable List<String> customLogMessageTags) {
        String logMessage = null;
        if (annotations != null) {
            Iterator<Annotation> iter = annotations.iterator();
            block0: while (iter.hasNext()) {
                Annotation annotation = iter.next();
                for (String defaultLogMessageKey : DEFAULT_LOG_MESSAGE_KEYS) {
                    if (!annotation.getKey().equals(defaultLogMessageKey)) continue;
                    iter.remove();
                    logMessage = annotation.getValue();
                    continue block0;
                }
            }
            if (logMessage == null && customLogMessageTags != null) {
                for (String tag : customLogMessageTags) {
                    iter = annotations.iterator();
                    while (iter.hasNext()) {
                        Annotation annotation = iter.next();
                        if (!annotation.getKey().equals(tag)) continue;
                        logMessage = annotation.getValue();
                        iter.remove();
                        break;
                    }
                    if (logMessage == null) continue;
                    break;
                }
            }
        }
        return logMessage == null ? "" : logMessage;
    }

    @Nullable
    public static Long getLogTimestamp(@Nullable List<Annotation> annotations, @Nullable List<String> customLogTimestampTags) {
        String timestampStr = null;
        if (annotations != null) {
            Iterator<Annotation> iter = annotations.iterator();
            block2: while (iter.hasNext()) {
                Annotation annotation = iter.next();
                for (String defaultLogTimestampKey : DEFAULT_LOG_TIMESTAMP_KEYS) {
                    if (!annotation.getKey().equals(defaultLogTimestampKey)) continue;
                    iter.remove();
                    timestampStr = annotation.getValue();
                    continue block2;
                }
            }
            if (timestampStr == null && customLogTimestampTags != null) {
                for (String tag : customLogTimestampTags) {
                    iter = annotations.iterator();
                    while (iter.hasNext()) {
                        Annotation annotation = iter.next();
                        if (!annotation.getKey().equals(tag)) continue;
                        timestampStr = annotation.getValue();
                        iter.remove();
                        break;
                    }
                    if (timestampStr == null) continue;
                    break;
                }
            }
        }
        if (timestampStr == null) {
            return Clock.now();
        }
        Long timestamp = null;
        try {
            timestamp = AbstractIngesterFormatter.timestampInMilliseconds(Double.parseDouble(timestampStr));
        }
        catch (NumberFormatException ignore) {
            timestamp = Clock.now();
        }
        return timestamp;
    }

    @Nullable
    public static String getLogApplication(@Nullable List<Annotation> annotations, @Nullable List<String> customLogApplicationTags) {
        String applicationStr = null;
        if (annotations != null) {
            Iterator<Annotation> iter = annotations.iterator();
            block0: while (iter.hasNext()) {
                Annotation annotation = iter.next();
                for (String defaultLogApplicationKey : DEFAULT_LOG_APPLICATION_KEYS) {
                    if (!annotation.getKey().equals(defaultLogApplicationKey)) continue;
                    iter.remove();
                    applicationStr = annotation.getValue();
                    continue block0;
                }
            }
            if (applicationStr == null && customLogApplicationTags != null) {
                for (String tag : customLogApplicationTags) {
                    iter = annotations.iterator();
                    while (iter.hasNext()) {
                        Annotation annotation = iter.next();
                        if (!annotation.getKey().equals(tag)) continue;
                        applicationStr = annotation.getValue();
                        iter.remove();
                        break;
                    }
                    if (applicationStr == null) continue;
                    break;
                }
            }
        }
        return applicationStr == null ? "none" : applicationStr;
    }

    @Nullable
    public static String getLogService(@Nullable List<Annotation> annotations, @Nullable List<String> customLogServiceTags) {
        String serviceStr = null;
        if (annotations != null) {
            Iterator<Annotation> iter = annotations.iterator();
            block0: while (iter.hasNext()) {
                Annotation annotation = iter.next();
                for (String defaultLogServiceKey : DEFAULT_LOG_SERVICE_KEYS) {
                    if (!annotation.getKey().equals(defaultLogServiceKey)) continue;
                    iter.remove();
                    serviceStr = annotation.getValue();
                    continue block0;
                }
            }
            if (serviceStr == null && customLogServiceTags != null) {
                for (String tag : customLogServiceTags) {
                    iter = annotations.iterator();
                    while (iter.hasNext()) {
                        Annotation annotation = iter.next();
                        if (!annotation.getKey().equals(tag)) continue;
                        serviceStr = annotation.getValue();
                        iter.remove();
                        break;
                    }
                    if (serviceStr == null) continue;
                    break;
                }
            }
        }
        return serviceStr == null ? "none" : serviceStr;
    }

    public static List<String> getDefaultLogMessageKeys() {
        return DEFAULT_LOG_MESSAGE_KEYS;
    }

    @Nullable
    public static String getLogLevel(@Nullable List<Annotation> annotations, @Nullable List<String> customLogLevelTags) {
        String logLvlStr = null;
        if (annotations != null) {
            Iterator<Annotation> iter = annotations.iterator();
            block0: while (iter.hasNext()) {
                Annotation annotation = iter.next();
                for (String defaultLogLevelKey : DEFAULT_LOG_LEVEL_KEYS) {
                    if (!annotation.getKey().equals(defaultLogLevelKey)) continue;
                    iter.remove();
                    logLvlStr = annotation.getValue();
                    continue block0;
                }
            }
            if (logLvlStr == null && customLogLevelTags != null) {
                for (String tag : customLogLevelTags) {
                    iter = annotations.iterator();
                    while (iter.hasNext()) {
                        Annotation annotation = iter.next();
                        if (!annotation.getKey().equals(tag)) continue;
                        logLvlStr = annotation.getValue();
                        iter.remove();
                        break;
                    }
                    if (logLvlStr == null) continue;
                    break;
                }
            }
        }
        return logLvlStr;
    }

    @Nullable
    public static String getLogException(@Nullable List<Annotation> annotations, @Nullable List<String> customLogExceptionTags) {
        String exceptionStr = null;
        if (annotations != null) {
            Iterator<Annotation> iter = annotations.iterator();
            block0: while (iter.hasNext()) {
                Annotation annotation = iter.next();
                for (String defaultLogExceptionKey : DEFAULT_LOG_EXCEPTION_KEYS) {
                    if (!annotation.getKey().equals(defaultLogExceptionKey)) continue;
                    iter.remove();
                    exceptionStr = annotation.getValue();
                    continue block0;
                }
            }
            if (exceptionStr == null && customLogExceptionTags != null) {
                for (String tag : customLogExceptionTags) {
                    iter = annotations.iterator();
                    while (iter.hasNext()) {
                        Annotation annotation = iter.next();
                        if (!annotation.getKey().equals(tag)) continue;
                        exceptionStr = annotation.getValue();
                        iter.remove();
                        break;
                    }
                    if (exceptionStr == null) continue;
                    break;
                }
            }
        }
        return exceptionStr;
    }

    public T drive(String input, @Nullable Supplier<String> defaultHostNameSupplier, String customerId) {
        return this.drive(input, defaultHostNameSupplier, customerId, null, null, null, null, null, null, null, null);
    }

    public abstract T drive(String var1, @Nullable Supplier<String> var2, String var3, @Nullable List<String> var4, @Nullable List<String> var5, @Nullable List<String> var6, List<String> var7, List<String> var8, @Nullable List<String> var9, @Nullable List<String> var10, @Nullable IngesterContext var11);

    public static class AnnotationList<T extends SpecificRecordBase>
    implements FormatterElement<T> {
        private final BiConsumer<T, List<Annotation>> annotationListConsumer;
        private final Function<T, List<Annotation>> annotationListProvider;
        private final Integer limit;
        private final Predicate<String> predicate;

        AnnotationList(BiConsumer<T, List<Annotation>> annotationListConsumer, Predicate<String> predicate) {
            this(annotationListConsumer, null, null, predicate);
        }

        AnnotationList(BiConsumer<T, List<Annotation>> annotationListConsumer, @Nullable Function<T, List<Annotation>> annotationListProvider, @Nullable Integer limit, @Nullable Predicate<String> predicate) {
            this.annotationListConsumer = annotationListConsumer;
            this.annotationListProvider = annotationListProvider;
            this.limit = limit;
            this.predicate = predicate;
        }

        @Override
        public void consume(StringParser parser, T target) {
            List<Annotation> annotations = null;
            if (this.annotationListProvider != null) {
                annotations = this.annotationListProvider.apply(target);
            }
            if (annotations == null) {
                annotations = new ArrayList<Annotation>();
            }
            List<Annotation> annotationList = annotations;
            for (int i = 0; parser.hasNext() && (this.limit == null || i < this.limit) && (this.predicate == null || this.predicate.test(parser.peek())); ++i) {
                AbstractIngesterFormatter.parseKeyValuePair(parser, (k, v) -> annotationList.add(new Annotation((String)k, (String)v)));
            }
            this.annotationListConsumer.accept(target, annotationList);
        }
    }

    public static class StringMultiMap<T extends SpecificRecordBase>
    implements FormatterElement<T> {
        private final BiConsumer<T, Map<String, List<String>>> annotationMultimapConsumer;

        StringMultiMap(BiConsumer<T, Map<String, List<String>>> annotationMultimapConsumer) {
            this.annotationMultimapConsumer = annotationMultimapConsumer;
        }

        @Override
        public void consume(StringParser parser, T target) {
            HashMap multimap = new HashMap();
            while (parser.hasNext()) {
                AbstractIngesterFormatter.parseKeyValuePair(parser, (k, v) -> multimap.computeIfAbsent(k, x -> new ArrayList()).add(v));
            }
            this.annotationMultimapConsumer.accept(target, multimap);
        }
    }

    public static class StringMap<T extends SpecificRecordBase>
    implements FormatterElement<T> {
        private final BiConsumer<T, Map<String, String>> stringMapConsumer;
        private final Function<T, Map<String, String>> stringMapProvider;
        private final Integer limit;
        private final Predicate<String> predicate;

        StringMap(BiConsumer<T, Map<String, String>> stringMapConsumer) {
            this(stringMapConsumer, null, null, null);
        }

        StringMap(BiConsumer<T, Map<String, String>> stringMapConsumer, @Nullable Function<T, Map<String, String>> stringMapProvider, @Nullable Integer limit, @Nullable Predicate<String> predicate) {
            this.stringMapConsumer = stringMapConsumer;
            this.stringMapProvider = stringMapProvider;
            this.limit = limit;
            this.predicate = predicate;
        }

        @Override
        public void consume(StringParser parser, T target) {
            Map<Object, Object> stringMap = null;
            if (this.stringMapProvider != null) {
                stringMap = this.stringMapProvider.apply(target);
            }
            if (stringMap == null) {
                stringMap = Maps.newHashMap();
            }
            for (int i = 0; parser.hasNext() && (this.limit == null || i < this.limit); ++i) {
                if (this.predicate != null) {
                    if (!this.predicate.test(parser.peek())) break;
                }
                AbstractIngesterFormatter.parseKeyValuePair(parser, stringMap::put);
            }
            this.stringMapConsumer.accept(target, stringMap);
        }
    }

    public static class StringList<T extends SpecificRecordBase>
    implements FormatterElement<T> {
        private final BiConsumer<T, List<String>> stringListConsumer;

        StringList(BiConsumer<T, List<String>> stringListConsumer) {
            this.stringListConsumer = stringListConsumer;
        }

        @Override
        public void consume(StringParser parser, T target) {
            ArrayList<String> list = new ArrayList<String>();
            while (parser.hasNext()) {
                list.add(parser.next());
            }
            this.stringListConsumer.accept(target, list);
        }
    }

    public static class Timestamp<T extends SpecificRecordBase>
    implements FormatterElement<T> {
        private final BiConsumer<T, Long> timestampConsumer;
        private final boolean optional;
        private final boolean raw;

        Timestamp(BiConsumer<T, Long> timestampConsumer, boolean optional, boolean raw) {
            this.timestampConsumer = timestampConsumer;
            this.optional = optional;
            this.raw = raw;
        }

        @Override
        public void consume(StringParser parser, T target) {
            Long timestamp = AbstractIngesterFormatter.parseTimestamp(parser, this.optional, this.raw);
            if (timestamp != null) {
                this.timestampConsumer.accept(target, timestamp);
            }
        }
    }

    public static class Centroids<T extends SpecificRecordBase>
    implements FormatterElement<T> {
        private static final String WEIGHT = "#";

        @Override
        public void consume(StringParser parser, T target) {
            ArrayList<Integer> counts = new ArrayList<Integer>();
            ArrayList<Double> bins = new ArrayList<Double>();
            while (WEIGHT.equals(parser.peek())) {
                parser.next();
                counts.add(Centroids.parse(parser.next(), "centroid weight", true).intValue());
                bins.add(Centroids.parse(parser.next(), "centroid value", false).doubleValue());
            }
            if (counts.size() == 0) {
                throw new ParseException("Empty histogram (no centroids)");
            }
            Histogram histogram = (Histogram)((Object)target.get("value"));
            histogram.setCounts(counts);
            histogram.setBins(bins);
        }

        private static Number parse(@Nullable String toParse, String name, boolean asInteger) {
            if (toParse == null) {
                throw new ParseException("Unexpected end of line, expected: " + name);
            }
            try {
                return asInteger ? (double)Integer.parseInt(toParse) : Double.parseDouble(toParse);
            }
            catch (NumberFormatException nef) {
                throw new ParseException("Expected: " + name + ", got: " + toParse);
            }
        }
    }

    public static class Value<T extends SpecificRecordBase>
    implements FormatterElement<T> {
        final BiConsumer<T, Double> valueConsumer;

        Value(BiConsumer<T, Double> valueConsumer) {
            this.valueConsumer = valueConsumer;
        }

        @Override
        public void consume(StringParser parser, T target) {
            String token = parser.next();
            if (token == null) {
                throw new ParseException("Value is missing");
            }
            try {
                this.valueConsumer.accept(target, Double.parseDouble(token));
            }
            catch (NumberFormatException nef) {
                throw new ParseException("Invalid value: " + token);
            }
        }
    }

    public static class Text<T extends SpecificRecordBase>
    implements FormatterElement<T> {
        final List<String> literals;
        final BiConsumer<T, String> textConsumer;
        final boolean isCaseSensitive;

        Text(@Nullable BiConsumer<T, String> textConsumer) {
            this(null, textConsumer, true);
        }

        Text(List<String> literals, @Nullable BiConsumer<T, String> textConsumer, boolean isCaseSensitive) {
            this.literals = literals;
            this.textConsumer = textConsumer;
            this.isCaseSensitive = isCaseSensitive;
        }

        @Override
        public void consume(StringParser parser, T target) {
            String text = parser.next();
            if (!this.isAllowedLiteral(text)) {
                throw new ParseException(AbstractIngesterFormatter.SINGLE_QUOTE_STR + text + "' is not allowed here!");
            }
            if (this.textConsumer != null) {
                this.textConsumer.accept(target, text);
            }
        }

        private boolean isAllowedLiteral(String literal) {
            if (this.literals == null) {
                return true;
            }
            for (String allowedLiteral : this.literals) {
                if (this.isCaseSensitive && literal.equals(allowedLiteral)) {
                    return true;
                }
                if (this.isCaseSensitive || !literal.equalsIgnoreCase(allowedLiteral)) continue;
                return true;
            }
            return false;
        }
    }

    public static abstract class IngesterFormatBuilder<T extends SpecificRecordBase> {
        final List<FormatterElement<T>> elements = Lists.newArrayList();

        public IngesterFormatBuilder<T> caseSensitiveLiterals(List<String> literals) {
            this.elements.add(new Text(literals, null, true));
            return this;
        }

        public IngesterFormatBuilder<T> caseSensitiveLiterals(List<String> literals, BiConsumer<T, String> textConsumer) {
            this.elements.add(new Text<T>(literals, textConsumer, true));
            return this;
        }

        public IngesterFormatBuilder<T> caseInsensitiveLiterals(List<String> literals) {
            this.elements.add(new Text(literals, null, false));
            return this;
        }

        public IngesterFormatBuilder<T> text(BiConsumer<T, String> textConsumer) {
            this.elements.add(new Text<T>(textConsumer));
            return this;
        }

        public IngesterFormatBuilder<T> value(BiConsumer<T, Double> valueConsumer) {
            this.elements.add(new Value<T>(valueConsumer));
            return this;
        }

        public IngesterFormatBuilder<T> centroids() {
            this.elements.add(new Centroids());
            return this;
        }

        public IngesterFormatBuilder<T> timestamp(BiConsumer<T, Long> timestampConsumer) {
            this.elements.add(new Timestamp<T>(timestampConsumer, false, false));
            return this;
        }

        public IngesterFormatBuilder<T> optionalTimestamp(BiConsumer<T, Long> timestampConsumer) {
            this.elements.add(new Timestamp<T>(timestampConsumer, true, false));
            return this;
        }

        public IngesterFormatBuilder<T> rawTimestamp(BiConsumer<T, Long> timestampConsumer) {
            this.elements.add(new Timestamp<T>(timestampConsumer, false, true));
            return this;
        }

        public IngesterFormatBuilder<T> annotationMap(BiConsumer<T, Map<String, String>> mapConsumer) {
            this.elements.add(new StringMap<T>(mapConsumer));
            return this;
        }

        public IngesterFormatBuilder<T> annotationMap(Function<T, Map<String, String>> mapProvider, BiConsumer<T, Map<String, String>> mapConsumer) {
            this.elements.add(new StringMap<T>(mapConsumer, mapProvider, null, null));
            return this;
        }

        public IngesterFormatBuilder<T> annotationMap(BiConsumer<T, Map<String, String>> mapConsumer, int limit) {
            this.elements.add(new StringMap<T>(mapConsumer, null, limit, null));
            return this;
        }

        public IngesterFormatBuilder<T> annotationList(BiConsumer<T, List<Annotation>> listConsumer) {
            this.elements.add(new AnnotationList<T>(listConsumer, null));
            return this;
        }

        public IngesterFormatBuilder<T> annotationList(BiConsumer<T, List<Annotation>> listConsumer, Predicate<String> stringPredicate) {
            this.elements.add(new AnnotationList<T>(listConsumer, stringPredicate));
            return this;
        }

        public IngesterFormatBuilder<T> annotationList(Function<T, List<Annotation>> listProvider, BiConsumer<T, List<Annotation>> listConsumer) {
            this.elements.add(new AnnotationList<T>(listConsumer, listProvider, null, null));
            return this;
        }

        public IngesterFormatBuilder<T> annotationList(BiConsumer<T, List<Annotation>> listConsumer, int limit) {
            this.elements.add(new AnnotationList<T>(listConsumer, null, limit, null));
            return this;
        }

        public IngesterFormatBuilder<T> annotationMultimap(BiConsumer<T, Map<String, List<String>>> multimapConsumer) {
            this.elements.add(new StringMultiMap<T>(multimapConsumer));
            return this;
        }

        public IngesterFormatBuilder<T> textList(BiConsumer<T, List<String>> listConsumer) {
            this.elements.add(new StringList<T>(listConsumer));
            return this;
        }

        public abstract AbstractIngesterFormatter<T> build();
    }

    protected static interface FormatterElement<T> {
        public void consume(StringParser var1, T var2);
    }
}

