/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.ingester;

import com.google.common.collect.ImmutableList;
import com.wavefront.ingester.AbstractIngesterFormatter;
import com.wavefront.ingester.IngesterContext;
import com.wavefront.ingester.ReportSourceTagIngesterFormatter;
import com.wavefront.ingester.ReportableEntityDecoder;
import java.util.List;
import java.util.Map;
import wavefront.report.ReportSourceTag;
import wavefront.report.SourceOperationType;
import wavefront.report.SourceTagAction;

public class ReportSourceTagDecoder
implements ReportableEntityDecoder<String, ReportSourceTag> {
    private static final String SOURCE = "source";
    private static final String ACTION = "action";
    private static final String ACTION_ADD = "add";
    private static final String ACTION_SAVE = "save";
    private static final String ACTION_DELETE = "delete";
    private static final AbstractIngesterFormatter<ReportSourceTag> FORMAT = ReportSourceTagIngesterFormatter.newBuilder().caseSensitiveLiterals((List<String>)ImmutableList.of((Object)"@SourceTag", (Object)"@SourceDescription"), ReportSourceTagDecoder::setOperation).annotationMap(ReportSourceTagDecoder::setKeywords, 2).textList(ReportSourceTag::setAnnotations).build();

    @Override
    public void decode(String msg, List<ReportSourceTag> out, String customerId, IngesterContext ctx) {
        ReportSourceTag tag = FORMAT.drive(msg, null, customerId, null, null, null, null, null, null, null, ctx);
        if (out == null) {
            return;
        }
        if ((tag.getAction() == SourceTagAction.ADD || tag.getAction() == SourceTagAction.DELETE) && tag.getAnnotations().size() > 1) {
            tag.getAnnotations().forEach(x -> out.add(ReportSourceTag.newBuilder(tag).setAnnotations((List<String>)ImmutableList.of((Object)x)).build()));
        } else {
            out.add(tag);
        }
    }

    private static void setOperation(ReportSourceTag target, String operation) {
        switch (operation) {
            case "@SourceTag": {
                target.setOperation(SourceOperationType.SOURCE_TAG);
                return;
            }
            case "@SourceDescription": {
                target.setOperation(SourceOperationType.SOURCE_DESCRIPTION);
                return;
            }
        }
        throw new IllegalArgumentException("Literal " + operation + " is not allowed!");
    }

    private static void setKeywords(ReportSourceTag target, Map<String, String> annotations) {
        String action = annotations.get(ACTION);
        if (action == null) {
            throw new IllegalArgumentException("No 'action' provided");
        }
        switch (action.toLowerCase()) {
            case "add": {
                target.setAction(SourceTagAction.ADD);
                break;
            }
            case "save": {
                target.setAction(SourceTagAction.SAVE);
                break;
            }
            case "delete": {
                target.setAction(SourceTagAction.DELETE);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid action '" + action + "'!");
            }
        }
        String source = annotations.get(SOURCE);
        if (source == null) {
            throw new IllegalArgumentException("No 'source' provided");
        }
        target.setSource(source);
    }
}

