/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.ingester;

import com.wavefront.data.ParseException;
import com.wavefront.ingester.AbstractIngesterFormatter;
import com.wavefront.ingester.IngesterContext;
import com.wavefront.ingester.StringParser;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import wavefront.report.Annotation;
import wavefront.report.Span;

public class SpanIngesterFormatter
extends AbstractIngesterFormatter<Span> {
    private SpanIngesterFormatter(List<AbstractIngesterFormatter.FormatterElement<Span>> elements) {
        super(elements);
    }

    public static AbstractIngesterFormatter.IngesterFormatBuilder<Span> newBuilder() {
        return new SpanFormatBuilder();
    }

    @Override
    public Span drive(String input, @Nullable Supplier<String> defaultHostNameSupplier, String customerId, @Nullable List<String> customSourceTags, @Nullable List<String> customLogTimestampTags, @Nullable List<String> customLogMessageTags, List<String> customLogApplicationTags, List<String> customLogServiceTags, @Nullable List<String> customLogLevelTags, @Nullable List<String> customLogExceptionTags, @Nullable IngesterContext ingesterContext) {
        Span span = new Span();
        span.setCustomer(customerId);
        StringParser parser = new StringParser(input);
        for (AbstractIngesterFormatter.FormatterElement element : this.elements) {
            element.consume(parser, span);
        }
        if (parser.hasNext()) {
            throw new ParseException("Unexpected extra input: " + parser.next());
        }
        List<Annotation> annotations = span.getAnnotations();
        if (annotations != null) {
            boolean hasTrueSource = false;
            Iterator<Annotation> iterator = annotations.iterator();
            while (iterator.hasNext()) {
                Annotation annotation = iterator.next();
                if (customSourceTags != null && !hasTrueSource && customSourceTags.contains(annotation.getKey())) {
                    span.setSource(annotation.getValue());
                }
                switch (annotation.getKey()) {
                    case "source": 
                    case "host": {
                        span.setSource(annotation.getValue());
                        iterator.remove();
                        hasTrueSource = true;
                        break;
                    }
                    case "spanId": {
                        span.setSpanId(annotation.getValue());
                        iterator.remove();
                        break;
                    }
                    case "traceId": {
                        span.setTraceId(annotation.getValue());
                        iterator.remove();
                        break;
                    }
                }
            }
        }
        if (span.getSource() == null && defaultHostNameSupplier != null) {
            span.setSource(defaultHostNameSupplier.get());
        }
        if (span.getSource() == null) {
            throw new IllegalArgumentException("source can't be null: " + input);
        }
        if (span.getSpanId() == null) {
            throw new IllegalArgumentException("spanId can't be null: " + input);
        }
        if (span.getTraceId() == null) {
            throw new IllegalArgumentException("traceId can't be null: " + input);
        }
        return span;
    }

    public static class SpanFormatBuilder
    extends AbstractIngesterFormatter.IngesterFormatBuilder<Span> {
        public SpanIngesterFormatter build() {
            return new SpanIngesterFormatter(this.elements);
        }
    }
}

