/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.dto;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.wavefront.dto.Log;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import wavefront.report.Annotation;
import wavefront.report.ReportLog;

public class LogDeserializer
extends JsonDeserializer<Log> {
    public Log deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        HashSet<String> specialFields = new HashSet<String>(Arrays.asList("timestamp", "text", "source"));
        long timestamp = node.get("timestamp").longValue();
        String message = node.get("text").asText();
        String source = node.get("source").asText();
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        Iterator fields = node.fields();
        while (fields.hasNext()) {
            Map.Entry field = (Map.Entry)fields.next();
            if (specialFields.contains(field.getKey())) continue;
            annotations.add(new Annotation((String)field.getKey(), ((JsonNode)field.getValue()).textValue()));
        }
        return new Log(new ReportLog(timestamp, message, source, annotations));
    }
}

