/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.ingester;

import com.google.common.base.Preconditions;
import com.wavefront.ingester.AbstractIngesterFormatter;
import com.wavefront.ingester.IngesterContext;
import com.wavefront.ingester.ReportableEntityDecoder;
import com.wavefront.ingester.SpanIngesterFormatter;
import java.util.List;
import java.util.function.Supplier;
import org.apache.commons.lang.StringUtils;
import wavefront.report.Span;

public class SpanDecoder
implements ReportableEntityDecoder<String, Span> {
    private static final AbstractIngesterFormatter<Span> FORMAT = SpanIngesterFormatter.newBuilder().text(Span::setName).annotationList(Span::setAnnotations, x -> !StringUtils.isNumeric((String)x)).rawTimestamp(Span::setStartMillis).rawTimestamp(SpanDecoder::setDuration).build();
    private final Supplier<String> hostNameSupplier;

    public SpanDecoder(String hostName) {
        this(() -> hostName);
    }

    public SpanDecoder(Supplier<String> hostNameSupplier) {
        Preconditions.checkNotNull(hostNameSupplier);
        this.hostNameSupplier = hostNameSupplier;
    }

    @Override
    public void decode(String msg, List<Span> out, String customerId, IngesterContext ctx) {
        Span span = FORMAT.drive(msg, this.hostNameSupplier, customerId, null, null, null, null, null, null, null, ctx);
        if (out != null) {
            out.add(span);
        }
    }

    private static void setDuration(Span span, Long durationTs) {
        Long startTs = span.getStartMillis();
        if (durationTs != null && startTs != null) {
            long duration;
            long l = duration = durationTs - startTs >= 0L ? durationTs - startTs : durationTs;
            if (startTs > 999999999999999999L) {
                span.setStartMillis(startTs / 1000000L);
                span.setDuration(duration / 1000000L);
            } else if (startTs > 999999999999999L) {
                span.setStartMillis(startTs / 1000L);
                span.setDuration(duration / 1000L);
            } else if (startTs > 999999999999L) {
                span.setDuration(duration);
            } else {
                span.setStartMillis(startTs * 1000L);
                span.setDuration(duration * 1000L);
            }
        } else {
            throw new IllegalArgumentException("Both timestamp and duration expected");
        }
    }
}

