/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.predicates;

import com.wavefront.predicates.StringExpression;
import com.wavefront.predicates.Util;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import wavefront.report.ReportHistogram;
import wavefront.report.ReportLog;
import wavefront.report.ReportMetric;
import wavefront.report.ReportPoint;
import wavefront.report.Span;

public class TemplateStringExpression
implements StringExpression {
    private final String template;

    public TemplateStringExpression(String template) {
        this.template = template;
    }

    @Override
    @Nonnull
    public String getString(@Nullable Object entity) {
        if (entity == null) {
            return this.template;
        }
        if (entity instanceof ReportMetric) {
            return Util.expandPlaceholders(this.template, (ReportMetric)((Object)entity));
        }
        if (entity instanceof ReportHistogram) {
            return Util.expandPlaceholders(this.template, (ReportHistogram)((Object)entity));
        }
        if (entity instanceof ReportPoint) {
            return Util.expandPlaceholders(this.template, (ReportPoint)((Object)entity));
        }
        if (entity instanceof Span) {
            return Util.expandPlaceholders(this.template, (Span)((Object)entity));
        }
        if (entity instanceof ReportLog) {
            return Util.expandPlaceholders(this.template, (ReportLog)((Object)entity));
        }
        throw new IllegalArgumentException(entity.getClass().getCanonicalName() + " is not supported!");
    }
}

