/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.ingester;

import com.google.common.collect.ImmutableList;
import com.tdunning.math.stats.AVLTreeDigest;
import com.tdunning.math.stats.Centroid;
import com.wavefront.data.ParseException;
import com.wavefront.data.TooManyCentroidException;
import com.wavefront.ingester.AbstractIngesterFormatter;
import com.wavefront.ingester.Decoder;
import com.wavefront.ingester.IngesterContext;
import com.wavefront.ingester.ReportPointIngesterFormatter;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import wavefront.report.Histogram;
import wavefront.report.HistogramType;
import wavefront.report.ReportPoint;

@Deprecated
public class HistogramDecoder
implements Decoder<String> {
    private static final AbstractIngesterFormatter<ReportPoint> FORMAT = ReportPointIngesterFormatter.newBuilder().caseSensitiveLiterals((List<String>)ImmutableList.of((Object)"!M", (Object)"!H", (Object)"!D"), HistogramDecoder::setBinType).optionalTimestamp(ReportPoint::setTimestamp).centroids().text(ReportPoint::setMetric).annotationMap(ReportPoint::setAnnotations).build();
    private final Supplier<String> defaultHostNameSupplier;

    public HistogramDecoder() {
        this("unknown");
    }

    public HistogramDecoder(String defaultHostName) {
        this(() -> defaultHostName);
    }

    public HistogramDecoder(Supplier<String> defaultHostNameSupplier) {
        this.defaultHostNameSupplier = defaultHostNameSupplier;
    }

    @Override
    public void decodeReportPoints(String msg, List<ReportPoint> out, String customerId) {
        this.decodeReportPoints(msg, out, customerId, (IngesterContext)null);
    }

    @Override
    public void decodeReportPoints(String msg, List<ReportPoint> out, String customerId, IngesterContext ctx) {
        ReportPoint histogram = FORMAT.drive(msg, this.defaultHostNameSupplier, customerId, null, null, null, null, null, null, null, ctx);
        if (histogram != null) {
            Histogram value = (Histogram)((Object)histogram.getValue());
            if (ctx != null) {
                if (value.getCounts().size() > ctx.getHistogramCentroidsLimit()) {
                    throw new TooManyCentroidException("Too many centroids (max: " + ctx.getHistogramCentroidsLimit() + ")");
                }
                if (ctx.isOptimizeHistograms()) {
                    HistogramDecoder.optimizeForStorage(value.getBins(), value.getCounts(), value.getCounts().size(), ctx.getTargetHistogramAccuracy());
                }
            }
            long duration = value.getDuration();
            histogram.setTimestamp(histogram.getTimestamp() / duration * duration);
            out.add(ReportPoint.newBuilder(histogram).build());
        }
    }

    @Override
    public void decodeReportPoints(String msg, List<ReportPoint> out) {
        throw new UnsupportedOperationException("Customer ID extraction is not supported");
    }

    private static void setBinType(ReportPoint target, String binType) {
        int durationMillis;
        switch (binType) {
            case "!M": {
                durationMillis = 60000;
                break;
            }
            case "!H": {
                durationMillis = 3600000;
                break;
            }
            case "!D": {
                durationMillis = 86400000;
                break;
            }
            default: {
                throw new ParseException("Unknown BinType " + binType);
            }
        }
        Histogram histogram = new Histogram();
        histogram.setDuration(durationMillis);
        histogram.setType(HistogramType.TDIGEST);
        target.setValue(histogram);
    }

    private static void optimizeForStorage(@Nullable List<Double> means, @Nullable List<Integer> counts, int size, int storageAccuracy) {
        if (means == null || means.isEmpty() || counts == null || counts.isEmpty()) {
            return;
        }
        if ((double)size > 2.0 * (double)storageAccuracy) {
            HistogramDecoder.rewrite(means, counts, storageAccuracy);
        }
        if (counts.stream().anyMatch(i -> i < 1)) {
            HistogramDecoder.rewrite(means, counts, storageAccuracy);
        } else {
            int strictlyIncreasingLength;
            for (strictlyIncreasingLength = 1; strictlyIncreasingLength < means.size() && !(means.get(strictlyIncreasingLength - 1) >= means.get(strictlyIncreasingLength)); ++strictlyIncreasingLength) {
            }
            if (strictlyIncreasingLength != means.size()) {
                HistogramDecoder.rewrite(means, counts, storageAccuracy);
            }
        }
    }

    private static void rewrite(List<Double> means, List<Integer> counts, int storageAccuracy) {
        AVLTreeDigest temp = new AVLTreeDigest((double)storageAccuracy);
        int size = Math.min(means.size(), counts.size());
        for (int i = 0; i < size; ++i) {
            int count = counts.get(i);
            if (count <= 0) continue;
            temp.add(means.get(i).doubleValue(), count);
        }
        temp.compress();
        means.clear();
        counts.clear();
        for (Centroid c : temp.centroids()) {
            means.add(c.mean());
            counts.add(c.count());
        }
    }
}

