/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.ingester;

import com.google.common.collect.ImmutableList;
import com.tdunning.math.stats.AVLTreeDigest;
import com.tdunning.math.stats.Centroid;
import com.wavefront.data.ParseException;
import com.wavefront.data.TooManyCentroidException;
import com.wavefront.ingester.AbstractIngesterFormatter;
import com.wavefront.ingester.IngesterContext;
import com.wavefront.ingester.ReportHistogramIngesterFormatter;
import com.wavefront.ingester.ReportableEntityDecoder;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import wavefront.report.Histogram;
import wavefront.report.HistogramType;
import wavefront.report.ReportHistogram;

public class ReportHistogramDecoder
implements ReportableEntityDecoder<String, ReportHistogram> {
    private static final AbstractIngesterFormatter<ReportHistogram> FORMAT = ReportHistogramIngesterFormatter.newBuilder().caseSensitiveLiterals((List<String>)ImmutableList.of((Object)"!M", (Object)"!H", (Object)"!D"), ReportHistogramDecoder::setBinType).optionalTimestamp(ReportHistogram::setTimestamp).centroids().text(ReportHistogram::setMetric).annotationList(ReportHistogram::setAnnotations).build();
    private final Supplier<String> defaultHostNameSupplier;

    public ReportHistogramDecoder() {
        this("unknown");
    }

    public ReportHistogramDecoder(String defaultHostName) {
        this(() -> defaultHostName);
    }

    public ReportHistogramDecoder(Supplier<String> defaultHostNameSupplier) {
        this.defaultHostNameSupplier = defaultHostNameSupplier;
    }

    @Override
    public void decode(String msg, List<ReportHistogram> out, String customerId, @Nullable IngesterContext ctx) {
        ReportHistogram histogram = FORMAT.drive(msg, this.defaultHostNameSupplier, customerId, null, null, null, null, null, null, null, ctx);
        if (histogram != null) {
            Histogram value = histogram.getValue();
            if (ctx != null) {
                if (value.getCounts().size() > ctx.getHistogramCentroidsLimit()) {
                    throw new TooManyCentroidException("Too many centroids (max: " + ctx.getHistogramCentroidsLimit() + ")");
                }
                if (ctx.isOptimizeHistograms()) {
                    ReportHistogramDecoder.optimizeForStorage(value.getBins(), value.getCounts(), value.getCounts().size(), ctx.getTargetHistogramAccuracy());
                }
            }
            long duration = value.getDuration();
            histogram.setTimestamp(histogram.getTimestamp() / duration * duration);
            out.add(ReportHistogram.newBuilder(histogram).build());
        }
    }

    @Override
    public void decode(String msg, List<ReportHistogram> out) {
        throw new UnsupportedOperationException("Customer ID extraction is not supported");
    }

    private static void setBinType(ReportHistogram target, String binType) {
        int durationMillis;
        switch (binType) {
            case "!M": {
                durationMillis = 60000;
                break;
            }
            case "!H": {
                durationMillis = 3600000;
                break;
            }
            case "!D": {
                durationMillis = 86400000;
                break;
            }
            default: {
                throw new ParseException("Unknown BinType " + binType);
            }
        }
        Histogram histogram = new Histogram();
        histogram.setDuration(durationMillis);
        histogram.setType(HistogramType.TDIGEST);
        target.setValue(histogram);
    }

    private static void optimizeForStorage(@Nullable List<Double> means, @Nullable List<Integer> counts, int size, int storageAccuracy) {
        if (means == null || means.isEmpty() || counts == null || counts.isEmpty()) {
            return;
        }
        if ((double)size > 2.0 * (double)storageAccuracy) {
            ReportHistogramDecoder.rewrite(means, counts, storageAccuracy);
        }
        if (counts.stream().anyMatch(i -> i < 1)) {
            ReportHistogramDecoder.rewrite(means, counts, storageAccuracy);
        } else {
            int strictlyIncreasingLength;
            for (strictlyIncreasingLength = 1; strictlyIncreasingLength < means.size() && !(means.get(strictlyIncreasingLength - 1) >= means.get(strictlyIncreasingLength)); ++strictlyIncreasingLength) {
            }
            if (strictlyIncreasingLength != means.size()) {
                ReportHistogramDecoder.rewrite(means, counts, storageAccuracy);
            }
        }
    }

    private static void rewrite(List<Double> means, List<Integer> counts, int storageAccuracy) {
        AVLTreeDigest temp = new AVLTreeDigest((double)storageAccuracy);
        int size = Math.min(means.size(), counts.size());
        for (int i = 0; i < size; ++i) {
            int count = counts.get(i);
            if (count <= 0) continue;
            temp.add(means.get(i).doubleValue(), count);
        }
        temp.compress();
        means.clear();
        counts.clear();
        for (Centroid c : temp.centroids()) {
            means.add(c.mean());
            counts.add(c.count());
        }
    }
}

