/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.ingester;

import com.wavefront.common.Clock;
import com.wavefront.data.ParseException;
import com.wavefront.ingester.AbstractIngesterFormatter;
import com.wavefront.ingester.IngesterContext;
import com.wavefront.ingester.StringParser;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import wavefront.report.ReportMetric;

public class ReportMetricIngesterFormatter
extends AbstractIngesterFormatter<ReportMetric> {
    private ReportMetricIngesterFormatter(List<AbstractIngesterFormatter.FormatterElement<ReportMetric>> elements) {
        super(elements);
    }

    public static AbstractIngesterFormatter.IngesterFormatBuilder<ReportMetric> newBuilder() {
        return new ReportMetricIngesterFormatBuilder();
    }

    @Override
    public ReportMetric drive(String input, Supplier<String> defaultHostNameSupplier, String customerId, @Nullable List<String> customSourceTags, @Nullable List<String> customLogTimestampTags, @Nullable List<String> customLogMessageTags, List<String> customLogApplicationTags, List<String> customLogServiceTags, @Nullable List<String> customLogLevelTags, @Nullable List<String> customLogExceptionTags, @Nullable IngesterContext ingesterContext) {
        ReportMetric point = new ReportMetric();
        point.setCustomer(customerId);
        point.setTimestamp(Clock.now());
        StringParser parser = new StringParser(input);
        for (AbstractIngesterFormatter.FormatterElement element : this.elements) {
            element.consume(parser, point);
        }
        if (parser.hasNext()) {
            throw new ParseException("Unexpected extra input: " + parser.next());
        }
        String host = AbstractIngesterFormatter.getHostAndNormalizeTags(point.getAnnotations(), customSourceTags, true);
        if (host == null) {
            host = defaultHostNameSupplier == null ? "unknown" : defaultHostNameSupplier.get();
        }
        point.setHost(host);
        return point;
    }

    public static class ReportMetricIngesterFormatBuilder
    extends AbstractIngesterFormatter.IngesterFormatBuilder<ReportMetric> {
        public ReportMetricIngesterFormatter build() {
            return new ReportMetricIngesterFormatter(this.elements);
        }
    }
}

