/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.predicates;

import com.wavefront.predicates.PredicateEvalExpression;

public class MathExpression
implements PredicateEvalExpression {
    private final PredicateEvalExpression left;
    private final PredicateEvalExpression right;
    private final String op;

    public MathExpression(PredicateEvalExpression left, PredicateEvalExpression right, String op) {
        this.left = left;
        this.right = right;
        this.op = op;
    }

    @Override
    public double getValue(Object entity) {
        switch (this.op) {
            case "and": {
                return PredicateEvalExpression.asDouble(PredicateEvalExpression.isTrue(this.left.getValue(entity)) && PredicateEvalExpression.isTrue(this.right.getValue(entity)));
            }
            case "or": {
                return PredicateEvalExpression.asDouble(PredicateEvalExpression.isTrue(this.left.getValue(entity)) || PredicateEvalExpression.isTrue(this.right.getValue(entity)));
            }
            case "+": {
                return this.left.getValue(entity) + this.right.getValue(entity);
            }
            case "-": {
                return this.left.getValue(entity) - this.right.getValue(entity);
            }
            case "*": {
                return this.left.getValue(entity) * this.right.getValue(entity);
            }
            case "/": {
                return this.left.getValue(entity) / this.right.getValue(entity);
            }
            case "%": {
                return this.left.getValue(entity) % this.right.getValue(entity);
            }
            case "=": {
                return PredicateEvalExpression.asDouble(this.left.getValue(entity) == this.right.getValue(entity));
            }
            case ">": {
                return PredicateEvalExpression.asDouble(this.left.getValue(entity) > this.right.getValue(entity));
            }
            case "<": {
                return PredicateEvalExpression.asDouble(this.left.getValue(entity) < this.right.getValue(entity));
            }
            case "<=": {
                return PredicateEvalExpression.asDouble(this.left.getValue(entity) <= this.right.getValue(entity));
            }
            case ">=": {
                return PredicateEvalExpression.asDouble(this.left.getValue(entity) >= this.right.getValue(entity));
            }
            case "!=": {
                return PredicateEvalExpression.asDouble(this.left.getValue(entity) != this.right.getValue(entity));
            }
            case "&": {
                return (long)this.left.getValue(entity) & (long)this.right.getValue(entity);
            }
            case "|": {
                return (long)this.left.getValue(entity) | (long)this.right.getValue(entity);
            }
            case "^": {
                return (long)this.left.getValue(entity) ^ (long)this.right.getValue(entity);
            }
            case ">>": {
                return (long)this.left.getValue(entity) >> (int)this.right.getValue(entity);
            }
            case ">>>": {
                return (long)this.left.getValue(entity) >>> (int)this.right.getValue(entity);
            }
            case "<<": 
            case "<<<": {
                return (long)this.left.getValue(entity) << (int)this.right.getValue(entity);
            }
        }
        throw new IllegalArgumentException("Unknown operator: " + this.op);
    }
}

