/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.ingester;

import com.google.common.base.Preconditions;
import com.wavefront.ingester.Decoder;
import com.wavefront.ingester.IngesterFormatter;
import java.util.List;
import sunnylabs.report.ReportPoint;

public class OpenTSDBDecoder
implements Decoder {
    private final String hostName;
    private static final IngesterFormatter FORMAT = IngesterFormatter.newBuilder().whiteSpace().appendCaseInsensitiveLiteral("put").whiteSpace().appendMetricName().whiteSpace().appendTimestamp().whiteSpace().appendValue().whiteSpace().appendAnnotationsConsumer().whiteSpace().build();

    public OpenTSDBDecoder() {
        this.hostName = "unknown";
    }

    public OpenTSDBDecoder(String hostName) {
        Preconditions.checkNotNull((Object)hostName);
        this.hostName = hostName;
    }

    @Override
    public void decodeReportPoints(String msg, List<ReportPoint> out, String customerId) {
        ReportPoint point = FORMAT.drive(msg, this.hostName, customerId);
        if (out != null) {
            out.add(point);
        }
    }

    @Override
    public void decodeReportPoints(String msg, List<ReportPoint> out) {
        ReportPoint point = FORMAT.drive(msg, this.hostName, "dummy");
        if (out != null) {
            out.add(point);
        }
    }
}

