/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.metrics;

import com.wavefront.common.TaggedMetricName;
import com.wavefront.metrics.JsonMetricsGenerator;
import com.wavefront.metrics.MetricTranslator;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import com.yammer.metrics.core.Timer;
import com.yammer.metrics.core.TimerContext;
import com.yammer.metrics.reporting.AbstractPollingReporter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.ws.rs.core.UriBuilder;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.BufferedSink;

public class JsonMetricsReporter
extends AbstractPollingReporter {
    private static final Logger logger = Logger.getLogger(JsonMetricsReporter.class.getCanonicalName());
    private static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private final boolean includeVMMetrics;
    private final String table;
    private final String sunnylabsHost;
    private final Integer sunnylabsPort;
    private final String host;
    private final Map<String, String> tags;
    private final Counter errors;
    private final boolean clearMetrics;
    private final boolean https;
    private final MetricTranslator metricTranslator;
    private final OkHttpClient client = new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).build();
    private Timer latency;
    private Counter reports;
    private final long START_TIME = System.currentTimeMillis();
    private final Gauge<Long> serverUptime = Metrics.newGauge((MetricName)new TaggedMetricName("service", "uptime"), (Gauge)new Gauge<Long>(){

        public Long value() {
            return System.currentTimeMillis() - JsonMetricsReporter.this.START_TIME;
        }
    });

    public JsonMetricsReporter(MetricsRegistry registry, String table, String sunnylabsHost, Map<String, String> tags, boolean clearMetrics) throws UnknownHostException {
        this(registry, true, table, sunnylabsHost, tags, clearMetrics);
    }

    public JsonMetricsReporter(MetricsRegistry registry, boolean includeVMMetrics, String table, String sunnylabsHost, Map<String, String> tags, boolean clearMetrics) throws UnknownHostException {
        this(registry, includeVMMetrics, table, sunnylabsHost, tags, clearMetrics, true, null);
    }

    public JsonMetricsReporter(MetricsRegistry registry, boolean includeVMMetrics, String table, String sunnylabsHost, Map<String, String> tags, boolean clearMetrics, boolean https, MetricTranslator metricTranslator) throws UnknownHostException {
        super(registry, "json-metrics-reporter");
        this.metricTranslator = metricTranslator;
        this.includeVMMetrics = includeVMMetrics;
        this.tags = tags;
        this.table = table;
        if (sunnylabsHost.contains(":")) {
            int idx = sunnylabsHost.indexOf(":");
            String host = sunnylabsHost.substring(0, idx);
            String strPort = sunnylabsHost.substring(idx + 1);
            Integer port = null;
            this.sunnylabsHost = host;
            try {
                port = Integer.parseInt(strPort);
            }
            catch (NumberFormatException e) {
                logger.log(Level.SEVERE, "Cannot infer port for JSON reporting", e);
            }
            this.sunnylabsPort = port;
        } else {
            this.sunnylabsHost = sunnylabsHost;
            this.sunnylabsPort = null;
        }
        this.clearMetrics = clearMetrics;
        this.host = InetAddress.getLocalHost().getHostName();
        this.https = https;
        if (!this.https) {
            logger.severe("===================================================================");
            logger.severe("HTTPS is off for reporting! This should never be set in production!");
            logger.severe("===================================================================");
        }
        this.latency = Metrics.newTimer((MetricName)new MetricName("jsonreporter", "jsonreporter", "latency"), (TimeUnit)TimeUnit.MILLISECONDS, (TimeUnit)TimeUnit.SECONDS);
        this.reports = Metrics.newCounter((MetricName)new MetricName("jsonreporter", "jsonreporter", "reports"));
        this.errors = Metrics.newCounter((MetricName)new MetricName("jsonreporter", "jsonreporter", "errors"));
    }

    public void run() {
        try {
            this.reportMetrics();
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Uncaught exception in reportMetrics loop", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportMetrics() {
        TimerContext time = this.latency.time();
        try {
            UriBuilder builder = UriBuilder.fromUri((URI)new URI(this.https ? "https" : "http", this.sunnylabsHost, "/report/metrics", null));
            if (this.sunnylabsPort != null) {
                builder.port(this.sunnylabsPort.intValue());
            }
            builder.queryParam("h", new Object[]{this.host});
            builder.queryParam("t", new Object[]{this.table});
            for (Map.Entry<String, String> tag : this.tags.entrySet()) {
                builder.queryParam(tag.getKey(), new Object[]{tag.getValue()});
            }
            URL http = builder.build(new Object[0]).toURL();
            logger.info("Reporting metrics (JSON) to: " + http);
            Request request = new Request.Builder().url(http).post(new RequestBody(){

                @Nullable
                public MediaType contentType() {
                    return JSON;
                }

                public void writeTo(BufferedSink bufferedSink) throws IOException {
                    JsonMetricsGenerator.generateJsonMetrics(bufferedSink.outputStream(), JsonMetricsReporter.this.getMetricsRegistry(), JsonMetricsReporter.this.includeVMMetrics, true, JsonMetricsReporter.this.clearMetrics, JsonMetricsReporter.this.metricTranslator);
                }
            }).build();
            try (Response response = this.client.newCall(request).execute();){
                logger.info("Metrics (JSON) reported: " + response.code());
            }
            this.reports.inc();
        }
        catch (Throwable e) {
            logger.log(Level.WARNING, "Failed to report metrics (JSON)", e);
            this.errors.inc();
        }
        finally {
            time.stop();
        }
    }
}

