/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.ingester;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.wavefront.ingester.IngesterFormatter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.IntStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import queryserver.parser.DSWrapperLexer;
import wavefront.report.Histogram;
import wavefront.report.HistogramType;
import wavefront.report.ReportPoint;
import wavefront.report.ReportSourceTag;

public abstract class AbstractIngesterFormatter<T> {
    private static final Logger logger = LoggerFactory.getLogger((String)AbstractIngesterFormatter.class.getCanonicalName());
    protected static final FormatterElement WHITESPACE_ELEMENT = new Whitespace();
    protected static final Pattern SINGLE_QUOTE_PATTERN = Pattern.compile("\\'", 16);
    protected static final Pattern DOUBLE_QUOTE_PATTERN = Pattern.compile("\\\"", 16);
    protected static final String DOUBLE_QUOTE_REPLACEMENT = Matcher.quoteReplacement("\"");
    protected static final String SINGLE_QUOTE_REPLACEMENT = Matcher.quoteReplacement("'");
    private static final BaseErrorListener THROWING_ERROR_LISTENER = new BaseErrorListener(){

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            throw new RuntimeException("Syntax error at line " + line + ", position " + charPositionInLine + ": " + msg, (Throwable)e);
        }
    };
    protected final List<FormatterElement> elements;
    protected static final ThreadLocal<DSWrapperLexer> dsWrapperLexerThreadLocal = new ThreadLocal<DSWrapperLexer>(){

        @Override
        protected DSWrapperLexer initialValue() {
            DSWrapperLexer lexer = new DSWrapperLexer((CharStream)new ANTLRInputStream(""));
            lexer.removeErrorListeners();
            lexer.addErrorListener((ANTLRErrorListener)THROWING_ERROR_LISTENER);
            return lexer;
        }
    };

    AbstractIngesterFormatter(List<FormatterElement> elements) {
        this.elements = elements;
    }

    protected Queue<Token> getQueue(String input) {
        DSWrapperLexer lexer = dsWrapperLexerThreadLocal.get();
        lexer.setInputStream((IntStream)new ANTLRInputStream(input));
        CommonTokenStream commonTokenStream = new CommonTokenStream((TokenSource)lexer);
        commonTokenStream.fill();
        List tokens = commonTokenStream.getTokens();
        if (tokens.isEmpty()) {
            throw new RuntimeException("Could not parse: " + input);
        }
        Queue queue = tokens.stream().filter(t -> t.getType() != -1).collect(Collectors.toCollection(ArrayDeque::new));
        return queue;
    }

    private static double parseValue(Queue<Token> tokenQueue, String name) {
        String value = "";
        Token current = tokenQueue.poll();
        if (current == null) {
            throw new RuntimeException("Invalid " + name + ", found EOF");
        }
        if (current.getType() == 4) {
            current = tokenQueue.poll();
            value = "-";
        }
        if (current == null) {
            throw new RuntimeException("Invalid " + name + ", found EOF");
        }
        if (current.getType() == 9) {
            if (!value.equals("")) {
                throw new RuntimeException("Invalid " + name + ": " + value + current.getText());
            }
            value = value + AbstractIngesterFormatter.unquote(current.getText());
        } else if (current.getType() == 8 || current.getType() == 10 || current.getType() == 7) {
            value = value + current.getText();
        } else {
            throw new RuntimeException("Invalid " + name + ": " + current.getText());
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException nef) {
            throw new RuntimeException("Invalid " + name + ": " + value);
        }
    }

    private static Long parseTimestamp(Queue<Token> tokenQueue, boolean optional) {
        Token peek = tokenQueue.peek();
        if (peek == null || peek.getType() != 7) {
            if (optional) {
                return null;
            }
            throw new RuntimeException("Expected timestamp, found " + (peek == null ? "EOF" : peek.getText()));
        }
        try {
            Double timestamp = Double.parseDouble(tokenQueue.poll().getText());
            Long timestampLong = timestamp.longValue();
            int timestampDigits = timestampLong.toString().length();
            if (timestampDigits == 19) {
                return timestampLong / 1000000L;
            }
            if (timestampDigits == 16) {
                return timestampLong / 1000L;
            }
            if (timestampDigits == 13) {
                return timestampLong;
            }
            return (long)(1000.0 * timestamp);
        }
        catch (NumberFormatException nfe) {
            throw new RuntimeException("Invalid timestamp value: " + peek.getText());
        }
    }

    protected static String getLiteral(Queue<Token> tokens) {
        StringBuilder toReturn = new StringBuilder();
        Token next = tokens.peek();
        if (next == null) {
            return "";
        }
        if (next.getType() == 9) {
            return AbstractIngesterFormatter.unquote(tokens.poll().getText());
        }
        while (next != null && (next.getType() == 8 || next.getType() == 11 || next.getType() == 7 || next.getType() == 15 || next.getType() == 16 || next.getType() == 10 || next.getType() == 3 || next.getType() == 4 || next.getType() == 6 || next.getType() == 17)) {
            toReturn.append(tokens.poll().getText());
            next = tokens.peek();
        }
        return toReturn.toString();
    }

    public static String unquote(String text) {
        if (text.startsWith("\"")) {
            text = DOUBLE_QUOTE_PATTERN.matcher(text.substring(1, text.length() - 1)).replaceAll(DOUBLE_QUOTE_REPLACEMENT);
        } else if (text.startsWith("'")) {
            text = SINGLE_QUOTE_PATTERN.matcher(text.substring(1, text.length() - 1)).replaceAll(SINGLE_QUOTE_REPLACEMENT);
        }
        return text;
    }

    public abstract T drive(String var1, String var2, String var3, List<String> var4);

    public static class Literal
    implements FormatterElement {
        private final String literal;
        private final boolean caseSensitive;

        public Literal(String literal, boolean caseSensitive) {
            this.literal = literal;
            this.caseSensitive = caseSensitive;
        }

        @Override
        public void consume(Queue<Token> tokenQueue, AbstractWrapper point) {
            if (tokenQueue.isEmpty()) {
                throw new RuntimeException("Expecting a literal string: " + this.literal + " but found EOF");
            }
            String literal = AbstractIngesterFormatter.getLiteral(tokenQueue);
            if (this.caseSensitive ? !literal.equals(this.literal) : !literal.equalsIgnoreCase(this.literal)) {
                throw new RuntimeException("Expecting a literal string: " + this.literal + " but found: " + literal);
            }
        }
    }

    public static class Literals
    implements FormatterElement {
        private final String[] literals;
        private final boolean caseSensitive;

        public Literals(String[] literals, boolean caseSensitive) {
            this.literals = literals;
            this.caseSensitive = caseSensitive;
        }

        @Override
        public void consume(Queue<Token> tokenQueue, AbstractWrapper point) {
            if (this.literals == null || this.literals.length != 2) {
                throw new RuntimeException("Sourcetag metadata parser is not properly initialized.");
            }
            if (tokenQueue.isEmpty()) {
                throw new RuntimeException("Expecting a literal string: " + this.literals[0] + " or " + this.literals[1] + " but found EOF");
            }
            String literal = AbstractIngesterFormatter.getLiteral(tokenQueue);
            if (this.caseSensitive) {
                for (String specLiteral : this.literals) {
                    if (!literal.equals(specLiteral)) continue;
                    point.setSourceTagLiteral(literal.substring(1));
                    return;
                }
                throw new RuntimeException("Expecting a literal string: " + this.literals[0] + " or " + this.literals[1] + " but found: " + literal);
            }
            for (String specLiteral : this.literals) {
                if (!literal.equalsIgnoreCase(specLiteral)) continue;
                point.setSourceTagLiteral(literal.substring(1));
                return;
            }
            throw new RuntimeException("Expecting a literal string: " + this.literals[0] + " or " + this.literals[1] + " but found: " + literal);
        }
    }

    public static class LoopOfValues
    implements FormatterElement {
        private final FormatterElement valueElement = new AlphaNumericValue();

        @Override
        public void consume(Queue<Token> tokenQueue, AbstractWrapper sourceTag) {
            while (!tokenQueue.isEmpty()) {
                WHITESPACE_ELEMENT.consume(tokenQueue, sourceTag);
                if (tokenQueue.isEmpty()) {
                    return;
                }
                this.valueElement.consume(tokenQueue, sourceTag);
            }
        }
    }

    public static class LoopOfKeywords
    implements FormatterElement {
        private final FormatterElement tagElement = new Keyword();

        @Override
        public void consume(Queue<Token> tokenQueue, AbstractWrapper sourceTag) {
            if (sourceTag.getSourceTagLiteral() == null) {
                throw new RuntimeException("Expected either @SourceTag or @SourceDescription in the message");
            }
            if (sourceTag.getSourceTagLiteral().equals("SourceTag")) {
                int max = 2;
                for (int count = 0; count < max; ++count) {
                    WHITESPACE_ELEMENT.consume(tokenQueue, sourceTag);
                    this.tagElement.consume(tokenQueue, sourceTag);
                }
            } else if (sourceTag.getSourceTagLiteral().equals("SourceDescription")) {
                while (!tokenQueue.isEmpty()) {
                    WHITESPACE_ELEMENT.consume(tokenQueue, sourceTag);
                    this.tagElement.consume(tokenQueue, sourceTag);
                }
            } else {
                throw new RuntimeException("Expected either @SourceTag or @SourceDescription in the message");
            }
        }
    }

    public static class Keyword
    implements FormatterElement {
        @Override
        public void consume(Queue<Token> queue, AbstractWrapper sourceTag) {
            String tagk = AbstractIngesterFormatter.getLiteral(queue);
            if (tagk.length() == 0) {
                throw new RuntimeException("Invalid tag name");
            }
            WHITESPACE_ELEMENT.consume(queue, sourceTag);
            Token current = queue.poll();
            if (current == null || current.getType() != 1) {
                throw new RuntimeException("Tag keys and values must be separated by '='" + (current != null ? ", found: " + current.getText() : ", found EOF"));
            }
            WHITESPACE_ELEMENT.consume(queue, sourceTag);
            String tagv = AbstractIngesterFormatter.getLiteral(queue);
            if (tagv.length() == 0) {
                throw new RuntimeException("Invalid tag value for: " + tagk);
            }
            switch (tagk) {
                case "action": {
                    sourceTag.setAction(tagv);
                    break;
                }
                case "source": {
                    sourceTag.setSource(tagv);
                    break;
                }
                case "description": {
                    sourceTag.setDescription(tagv);
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown tag key = " + tagk + " specified.");
                }
            }
        }
    }

    public static class Whitespace
    implements FormatterElement {
        @Override
        public void consume(Queue<Token> tokens, AbstractWrapper point) {
            while (!tokens.isEmpty() && tokens.peek().getType() == 18) {
                tokens.poll();
            }
        }
    }

    public static class Metric
    implements FormatterElement {
        @Override
        public void consume(Queue<Token> tokenQueue, AbstractWrapper point) {
            String metric = AbstractIngesterFormatter.getLiteral(tokenQueue);
            if (metric.length() == 0) {
                throw new RuntimeException("Invalid metric name");
            }
            point.setMetric(metric);
        }
    }

    public static class Timestamp
    implements FormatterElement {
        private final TimeUnit timeUnit;
        private final boolean optional;

        public Timestamp(TimeUnit timeUnit, boolean optional) {
            this.timeUnit = timeUnit;
            this.optional = optional;
        }

        @Override
        public void consume(Queue<Token> tokenQueue, AbstractWrapper point) {
            Token peek = tokenQueue.peek();
            if (peek == null) {
                if (this.optional) {
                    return;
                }
                throw new RuntimeException("Expecting timestamp, found EOF");
            }
            if (peek.getType() == 7) {
                try {
                    long multiplier = this.timeUnit.toMillis(1L);
                    if (multiplier < 1L) {
                        point.setTimestamp(this.timeUnit.toMillis((long)Double.parseDouble(tokenQueue.poll().getText())));
                    }
                    point.setTimestamp((long)((double)multiplier * Double.parseDouble(tokenQueue.poll().getText())));
                }
                catch (NumberFormatException nfe) {
                    throw new RuntimeException("Invalid timestamp value: " + peek.getText());
                }
            } else if (!this.optional) {
                throw new RuntimeException("Expecting timestamp, found: " + peek.getText());
            }
        }
    }

    public static class AdaptiveTimestamp
    implements FormatterElement {
        private final boolean optional;

        public AdaptiveTimestamp(boolean optional) {
            this.optional = optional;
        }

        @Override
        public void consume(Queue<Token> tokenQueue, AbstractWrapper point) {
            Long timestamp = AbstractIngesterFormatter.parseTimestamp(tokenQueue, this.optional);
            if (timestamp != null) {
                point.setTimestamp(timestamp);
            }
        }
    }

    public static class Value
    implements FormatterElement {
        @Override
        public void consume(Queue<Token> tokenQueue, AbstractWrapper point) {
            point.setValue(AbstractIngesterFormatter.parseValue(tokenQueue, "metric value"));
        }
    }

    public static class AlphaNumericValue
    implements FormatterElement {
        @Override
        public void consume(Queue<Token> tokenQueue, AbstractWrapper sourceTag) {
            WHITESPACE_ELEMENT.consume(tokenQueue, sourceTag);
            String value = "";
            Token current = tokenQueue.poll();
            if (current == null) {
                throw new RuntimeException("Invalid value, found EOF");
            }
            if (current == null) {
                throw new RuntimeException("Invalid value, found EOF");
            }
            if (current.getType() == 9) {
                if (!value.equals("")) {
                    throw new RuntimeException("invalid metric value: " + value + current.getText());
                }
                value = value + IngesterFormatter.unquote(current.getText());
            } else if (current.getType() == 8 || current.getType() == 10 || current.getType() == 7) {
                value = value + current.getText();
            } else {
                throw new RuntimeException("invalid value: " + current.getText());
            }
            sourceTag.addToAnnotations(value);
        }
    }

    public static class Tag
    implements FormatterElement {
        @Override
        public void consume(Queue<Token> queue, AbstractWrapper point) {
            String tagk = AbstractIngesterFormatter.getLiteral(queue);
            if (tagk.length() == 0) {
                throw new RuntimeException("Invalid tag name");
            }
            WHITESPACE_ELEMENT.consume(queue, point);
            Token current = queue.poll();
            if (current == null || current.getType() != 1) {
                throw new RuntimeException("Tag keys and values must be separated by '='" + (current != null ? ", found: " + current.getText() : ", found EOF"));
            }
            WHITESPACE_ELEMENT.consume(queue, point);
            String tagv = AbstractIngesterFormatter.getLiteral(queue);
            if (tagv.length() == 0) {
                throw new RuntimeException("Invalid tag value for: " + tagk);
            }
            if (point.getAnnotations() == null) {
                point.setAnnotations(Maps.newHashMap());
            }
            point.getAnnotations().put(tagk, tagv);
        }
    }

    public static class TimestampAdjuster
    implements FormatterElement {
        @Override
        public void consume(Queue<Token> tokenQueue, AbstractWrapper point) {
            Preconditions.checkArgument((point.getValue() != null && point.getTimestamp() != null && point.getValue() instanceof Histogram && ((Histogram)((Object)point.getValue())).getDuration() != null ? 1 : 0) != 0, (Object)"Expected a histogram point with timestamp and histogram duration");
            long duration = ((Histogram)((Object)point.getValue())).getDuration().intValue();
            point.setTimestamp(point.getTimestamp() / duration * duration);
        }
    }

    public static class GuardedLoop
    implements FormatterElement {
        private final FormatterElement element;
        private final int acceptedToken;
        private final boolean optional;

        public GuardedLoop(FormatterElement element, int acceptedToken, boolean optional) {
            this.element = element;
            this.acceptedToken = acceptedToken;
            this.optional = optional;
        }

        @Override
        public void consume(Queue<Token> tokenQueue, AbstractWrapper point) {
            boolean satisfied = this.optional;
            while (!tokenQueue.isEmpty()) {
                WHITESPACE_ELEMENT.consume(tokenQueue, point);
                if (tokenQueue.peek() == null || tokenQueue.peek().getType() != this.acceptedToken) break;
                satisfied = true;
                this.element.consume(tokenQueue, point);
            }
            if (!satisfied) {
                throw new RuntimeException("Expected at least one element, got none");
            }
        }
    }

    public static class Centroid
    implements FormatterElement {
        public static int expectedToken() {
            return 13;
        }

        @Override
        public void consume(Queue<Token> tokenQueue, AbstractWrapper point) {
            int count;
            Token peek = tokenQueue.peek();
            Preconditions.checkNotNull((Object)peek, (Object)"Expected Count, got EOF");
            Preconditions.checkArgument((peek.getType() == 13 ? 1 : 0) != 0, (Object)("Expected Count, got " + peek.getText()));
            String countStr = tokenQueue.poll().getText();
            try {
                count = Integer.parseInt(countStr.substring(1));
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Could not parse count " + countStr);
            }
            WHITESPACE_ELEMENT.consume(tokenQueue, point);
            double mean = AbstractIngesterFormatter.parseValue(tokenQueue, "centroid mean");
            Histogram h = (Histogram)((Object)MoreObjects.firstNonNull((Object)((Object)((Histogram)((Object)point.getValue()))), (Object)((Object)new Histogram())));
            List bins = (List)MoreObjects.firstNonNull(h.getBins(), new ArrayList());
            bins.add(mean);
            h.setBins(bins);
            List counts = (List)MoreObjects.firstNonNull(h.getCounts(), new ArrayList());
            counts.add(count);
            h.setCounts(counts);
            point.setValue(h);
        }
    }

    public static class BinType
    implements FormatterElement {
        @Override
        public void consume(Queue<Token> tokenQueue, AbstractWrapper point) {
            String binType;
            Token peek = tokenQueue.peek();
            if (peek == null) {
                throw new RuntimeException("Expected BinType, found EOF");
            }
            if (peek.getType() != 12) {
                throw new RuntimeException("Expected BinType, found " + peek.getText());
            }
            int durationMillis = 0;
            switch (binType = tokenQueue.poll().getText()) {
                case "!M": {
                    durationMillis = 60000;
                    break;
                }
                case "!H": {
                    durationMillis = 3600000;
                    break;
                }
                case "!D": {
                    durationMillis = 86400000;
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown BinType " + binType);
                }
            }
            Histogram h = (Histogram)((Object)MoreObjects.firstNonNull((Object)((Object)((Histogram)((Object)point.getValue()))), (Object)((Object)new Histogram())));
            h.setDuration(durationMillis);
            h.setType(HistogramType.TDIGEST);
            point.setValue(h);
        }
    }

    public static class Loop
    implements FormatterElement {
        private final FormatterElement element;

        public Loop(FormatterElement element) {
            this.element = element;
        }

        @Override
        public void consume(Queue<Token> tokenQueue, AbstractWrapper point) {
            while (!tokenQueue.isEmpty()) {
                WHITESPACE_ELEMENT.consume(tokenQueue, point);
                if (tokenQueue.isEmpty()) {
                    return;
                }
                this.element.consume(tokenQueue, point);
            }
        }
    }

    public static abstract class IngesterFormatBuilder {
        protected final List<FormatterElement> elements = Lists.newArrayList();

        public IngesterFormatBuilder appendCaseSensitiveLiteral(String literal) {
            this.elements.add(new Literal(literal, true));
            return this;
        }

        public IngesterFormatBuilder appendCaseSensitiveLiterals(String[] literals) {
            this.elements.add(new Literals(literals, true));
            return this;
        }

        public IngesterFormatBuilder appendCaseInsensitiveLiteral(String literal) {
            this.elements.add(new Literal(literal, false));
            return this;
        }

        public IngesterFormatBuilder appendMetricName() {
            this.elements.add(new Metric());
            return this;
        }

        public IngesterFormatBuilder appendValue() {
            this.elements.add(new Value());
            return this;
        }

        public IngesterFormatBuilder appendTimestamp() {
            this.elements.add(new AdaptiveTimestamp(false));
            return this;
        }

        public IngesterFormatBuilder appendOptionalTimestamp() {
            this.elements.add(new AdaptiveTimestamp(true));
            return this;
        }

        public IngesterFormatBuilder appendTimestamp(TimeUnit timeUnit) {
            this.elements.add(new Timestamp(timeUnit, false));
            return this;
        }

        public IngesterFormatBuilder appendOptionalTimestamp(TimeUnit timeUnit) {
            this.elements.add(new Timestamp(timeUnit, true));
            return this;
        }

        public IngesterFormatBuilder appendAnnotationsConsumer() {
            this.elements.add(new Loop(new Tag()));
            return this;
        }

        public IngesterFormatBuilder whiteSpace() {
            this.elements.add(new Whitespace());
            return this;
        }

        public IngesterFormatBuilder binType() {
            this.elements.add(new BinType());
            return this;
        }

        public IngesterFormatBuilder centroids() {
            this.elements.add(new GuardedLoop(new Centroid(), Centroid.expectedToken(), false));
            return this;
        }

        public IngesterFormatBuilder adjustTimestamp() {
            this.elements.add(new TimestampAdjuster());
            return this;
        }

        public IngesterFormatBuilder appendLoopOfKeywords() {
            this.elements.add(new LoopOfKeywords());
            return this;
        }

        public IngesterFormatBuilder appendLoopOfValues() {
            this.elements.add(new LoopOfValues());
            return this;
        }

        public abstract AbstractIngesterFormatter build();
    }

    protected static interface FormatterElement {
        public void consume(Queue<Token> var1, AbstractWrapper var2);
    }

    protected static class ReportSourceTagWrapper
    extends AbstractWrapper {
        ReportSourceTag reportSourceTag;

        ReportSourceTagWrapper(ReportSourceTag reportSourceTag) {
            this.reportSourceTag = reportSourceTag;
        }

        @Override
        String getSourceTagLiteral() {
            return this.reportSourceTag.getSourceTagLiteral();
        }

        @Override
        void setSourceTagLiteral(String literal) {
            this.reportSourceTag.setSourceTagLiteral(literal);
        }

        @Override
        void setAnnotations(List<String> annotations) {
            this.reportSourceTag.setAnnotations(annotations);
        }

        @Override
        void setSource(String source) {
            this.reportSourceTag.setSource(source);
        }

        @Override
        void setAction(String action) {
            this.reportSourceTag.setAction(action);
        }

        @Override
        void setDescription(String description) {
            this.reportSourceTag.setDescription(description);
        }

        @Override
        void addToAnnotations(String value) {
            if (this.reportSourceTag.getAnnotations() == null) {
                this.reportSourceTag.setAnnotations(Lists.newArrayList());
            }
            this.reportSourceTag.getAnnotations().add(value);
        }
    }

    protected static class ReportPointWrapper
    extends AbstractWrapper {
        ReportPoint reportPoint;

        ReportPointWrapper(ReportPoint reportPoint) {
            this.reportPoint = reportPoint;
        }

        @Override
        Object getValue() {
            return this.reportPoint.getValue();
        }

        @Override
        void setValue(Histogram value) {
            this.reportPoint.setValue(value);
        }

        @Override
        void setValue(double value) {
            this.reportPoint.setValue(value);
        }

        @Override
        void setValue(String value) {
            this.reportPoint.setValue(value);
        }

        @Override
        void setValue(Long value) {
            this.reportPoint.setValue(value);
        }

        @Override
        Long getTimestamp() {
            return this.reportPoint.getTimestamp();
        }

        @Override
        void setTimestamp(Long value) {
            this.reportPoint.setTimestamp(value);
        }

        @Override
        Map<String, String> getAnnotations() {
            return this.reportPoint.getAnnotations();
        }

        @Override
        void setAnnotations(Map<String, String> annotations) {
            this.reportPoint.setAnnotations(annotations);
        }

        @Override
        void setMetric(String value) {
            this.reportPoint.setMetric(value);
        }
    }

    protected static abstract class AbstractWrapper {
        protected AbstractWrapper() {
        }

        Object getValue() {
            throw new UnsupportedOperationException("Should not be invoked.");
        }

        void setValue(Histogram value) {
            throw new UnsupportedOperationException("Should not be invoked.");
        }

        void setValue(double value) {
            throw new UnsupportedOperationException("Should not be invoked.");
        }

        void setValue(String value) {
            throw new UnsupportedOperationException("Should not be invoked.");
        }

        void setValue(Long value) {
            throw new UnsupportedOperationException("Should not be invoked.");
        }

        Long getTimestamp() {
            throw new UnsupportedOperationException("Should not be invoked.");
        }

        void setTimestamp(Long value) {
            throw new UnsupportedOperationException("Should not be invoked.");
        }

        Map<String, String> getAnnotations() {
            throw new UnsupportedOperationException("Should not be invoked.");
        }

        void setAnnotations(Map<String, String> annotations) {
            throw new UnsupportedOperationException("Should not be invoked.");
        }

        void setAnnotations(List<String> annotations) {
            throw new UnsupportedOperationException("Should not be invoked.");
        }

        void addToAnnotations(String value) {
            throw new UnsupportedOperationException("Should not be invoked.");
        }

        void setMetric(String value) {
            throw new UnsupportedOperationException("Should not be invoked.");
        }

        String getSourceTagLiteral() {
            throw new UnsupportedOperationException("Should not be invoked.");
        }

        void setSourceTagLiteral(String literal) {
            throw new UnsupportedOperationException("Should not be invoked.");
        }

        void setAction(String action) {
            throw new UnsupportedOperationException("Should not be invoked.");
        }

        void setSource(String source) {
            throw new UnsupportedOperationException("Should not be invoked.");
        }

        void setDescription(String description) {
            throw new UnsupportedOperationException("Should not be invoked.");
        }
    }
}

