/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.ingester;

import java.util.function.Function;
import org.apache.commons.lang.StringUtils;
import wavefront.report.Annotation;
import wavefront.report.Span;

public class SpanSerializer
implements Function<Span, String> {
    private static String quote = "\"";
    private static String escapedQuote = "\\\"";

    @Override
    public String apply(Span span) {
        return SpanSerializer.spanToString(span);
    }

    private static String escapeQuotes(String raw) {
        return StringUtils.replace((String)raw, (String)quote, (String)escapedQuote);
    }

    static String spanToString(Span span) {
        StringBuilder sb = new StringBuilder(quote).append(SpanSerializer.escapeQuotes(span.getName())).append(quote).append(' ');
        if (span.getSource() != null) {
            sb.append("source=").append(quote).append(SpanSerializer.escapeQuotes(span.getSource())).append(quote).append(' ');
        }
        if (span.getSpanId() != null) {
            sb.append("spanId=").append(quote).append(SpanSerializer.escapeQuotes(span.getSpanId())).append(quote).append(' ');
        }
        if (span.getTraceId() != null) {
            sb.append("traceId=").append(quote).append(SpanSerializer.escapeQuotes(span.getTraceId())).append(quote);
        }
        if (span.getAnnotations() != null) {
            for (Annotation entry : span.getAnnotations()) {
                sb.append(' ').append(quote).append(SpanSerializer.escapeQuotes(entry.getKey())).append(quote).append("=").append(quote).append(SpanSerializer.escapeQuotes(entry.getValue())).append(quote);
            }
        }
        sb.append(' ').append(span.getStartMillis()).append(' ').append(span.getDuration());
        return sb.toString();
    }
}

