/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.metrics.core;

import com.sun.management.UnixOperatingSystemMXBean;
import com.yammer.metrics.core.VirtualMachineMetrics;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.util.List;
import javax.management.MBeanServer;

public class SafeVirtualMachineMetrics
extends VirtualMachineMetrics {
    private static final VirtualMachineMetrics INSTANCE = new SafeVirtualMachineMetrics(ManagementFactory.getMemoryMXBean(), ManagementFactory.getMemoryPoolMXBeans(), ManagementFactory.getOperatingSystemMXBean(), ManagementFactory.getThreadMXBean(), ManagementFactory.getGarbageCollectorMXBeans(), ManagementFactory.getRuntimeMXBean(), ManagementFactory.getPlatformMBeanServer());
    private final OperatingSystemMXBean os;

    public static VirtualMachineMetrics getInstance() {
        return INSTANCE;
    }

    private SafeVirtualMachineMetrics(MemoryMXBean memory, List<MemoryPoolMXBean> memoryPools, OperatingSystemMXBean os, ThreadMXBean threads, List<GarbageCollectorMXBean> garbageCollectors, RuntimeMXBean runtime, MBeanServer mBeanServer) {
        super(memory, memoryPools, os, threads, garbageCollectors, runtime, mBeanServer);
        this.os = os;
    }

    public double fileDescriptorUsage() {
        if (!(this.os instanceof UnixOperatingSystemMXBean)) {
            return Double.NaN;
        }
        Long openFds = ((UnixOperatingSystemMXBean)this.os).getOpenFileDescriptorCount();
        Long maxFds = ((UnixOperatingSystemMXBean)this.os).getMaxFileDescriptorCount();
        return openFds.doubleValue() / maxFds.doubleValue();
    }
}

