/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.sdk.dropwizard.reporter;

import com.codahale.metrics.MetricRegistry;
import com.wavefront.dropwizard.metrics.DropwizardMetricsReporter;
import com.wavefront.sdk.common.WavefrontSender;
import com.wavefront.sdk.common.application.ApplicationTags;
import com.wavefront.sdk.common.application.HeartbeaterService;
import com.wavefront.sdk.entities.metrics.WavefrontMetricSender;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class WavefrontDropwizardReporter {
    private final DropwizardMetricsReporter dropwizardMetricsReporter;
    private final int reportingIntervalSeconds;
    private final HeartbeaterService heartbeaterService;

    private WavefrontDropwizardReporter(DropwizardMetricsReporter dropwizardMetricsReporter, int reportingIntervalSeconds, WavefrontMetricSender wavefrontMetricSender, ApplicationTags applicationTags, String source) {
        this.dropwizardMetricsReporter = dropwizardMetricsReporter;
        this.reportingIntervalSeconds = reportingIntervalSeconds;
        this.heartbeaterService = new HeartbeaterService(wavefrontMetricSender, applicationTags, "dropwizard", source);
    }

    public void start() {
        this.dropwizardMetricsReporter.start((long)this.reportingIntervalSeconds, TimeUnit.SECONDS);
    }

    public void stop() {
        this.dropwizardMetricsReporter.stop();
        this.heartbeaterService.close();
    }

    public static class Builder {
        private final MetricRegistry metricRegistry;
        private final ApplicationTags applicationTags;
        private final String prefix = "dw";
        private int reportingIntervalSeconds = 60;
        @Nullable
        private String source;

        public Builder(MetricRegistry metricRegistry, ApplicationTags applicationTags) {
            this.metricRegistry = metricRegistry;
            this.applicationTags = applicationTags;
        }

        public Builder reportingIntervalSeconds(int reportingIntervalSeconds) {
            this.reportingIntervalSeconds = reportingIntervalSeconds;
            return this;
        }

        public Builder withSource(String source) {
            this.source = source;
            return this;
        }

        public WavefrontDropwizardReporter build(WavefrontSender wavefrontSender) {
            if (this.source == null) {
                try {
                    this.source = InetAddress.getLocalHost().getHostName();
                }
                catch (UnknownHostException e) {
                    this.source = "unknown";
                }
            }
            HashMap<String, String> pointTags = new HashMap<String, String>();
            pointTags.put("application", this.applicationTags.getApplication());
            pointTags.put("service", this.applicationTags.getService());
            pointTags.put("cluster", this.applicationTags.getCluster() == null ? "none" : this.applicationTags.getCluster());
            pointTags.put("shard", this.applicationTags.getShard() == null ? "none" : this.applicationTags.getShard());
            if (this.applicationTags.getCustomTags() != null) {
                pointTags.putAll(this.applicationTags.getCustomTags());
            }
            DropwizardMetricsReporter dropwizardMetricsReporter = DropwizardMetricsReporter.forRegistry((MetricRegistry)this.metricRegistry).prefixedWith("dw").withSource(this.source).withReporterPointTags(pointTags).build(wavefrontSender);
            return new WavefrontDropwizardReporter(dropwizardMetricsReporter, this.reportingIntervalSeconds, (WavefrontMetricSender)wavefrontSender, this.applicationTags, this.source);
        }
    }
}

