/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.sdk.entities.tracing.sampling;

import com.wavefront.sdk.entities.tracing.sampling.Sampler;
import java.util.List;

public class CompositeSampler
implements Sampler {
    private final List<Sampler> samplers;

    public CompositeSampler(List<Sampler> samplers) {
        this.samplers = samplers;
    }

    @Override
    public boolean sample(String operationName, long traceId, long duration) {
        if (this.samplers == null || this.samplers.isEmpty()) {
            return true;
        }
        for (Sampler sampler : this.samplers) {
            if (!sampler.sample(operationName, traceId, duration)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEarly() {
        return false;
    }
}

