/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.sdk.common;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.wavefront.sdk.common.Pair;
import com.wavefront.sdk.common.annotation.NonNull;
import com.wavefront.sdk.common.annotation.Nullable;
import com.wavefront.sdk.entities.histograms.HistogramGranularity;
import com.wavefront.sdk.entities.tracing.SpanLog;
import com.wavefront.sdk.entities.tracing.SpanLogsDTO;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Utils {
    private static final Logger logger = Logger.getLogger(Utils.class.getCanonicalName());
    private static final ObjectMapper JSON_PARSER = new ObjectMapper();

    public static String sanitize(String s) {
        return Utils.sanitizeInternal(s, true);
    }

    public static String sanitizeWithoutQuotes(String s) {
        return Utils.sanitizeInternal(s, false);
    }

    public static String sanitizeValue(String s) {
        String res = s.trim();
        if (s.contains("\"") || s.contains("'")) {
            res = res.replaceAll("\"", "\\\\\"");
        }
        return "\"" + res.replaceAll("\\n", "\\\\n") + "\"";
    }

    public static String metricToLineData(String name, double value, @Nullable Long timestamp, String source, @Nullable Map<String, String> tags, String defaultSource) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("metrics name cannot be blank");
        }
        if (source == null || source.isEmpty()) {
            source = defaultSource;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(Utils.sanitize(name));
        sb.append(' ');
        sb.append(value);
        if (timestamp != null) {
            sb.append(' ');
            sb.append(timestamp);
        }
        sb.append(" source=");
        sb.append(Utils.sanitize(source));
        if (tags != null) {
            for (Map.Entry<String, String> tag : tags.entrySet()) {
                String key = tag.getKey();
                String val = tag.getValue();
                if (key == null || key.isEmpty()) {
                    throw new IllegalArgumentException("metric point tag key cannot be blank");
                }
                if (val == null || val.isEmpty()) {
                    throw new IllegalArgumentException("metric point tag value cannot be blank for tag key: " + key);
                }
                sb.append(' ');
                sb.append(Utils.sanitize(key));
                sb.append('=');
                sb.append(Utils.sanitizeValue(val));
            }
        }
        sb.append('\n');
        return sb.toString();
    }

    public static String histogramToLineData(String name, List<Pair<Double, Integer>> centroids, Set<HistogramGranularity> histogramGranularities, @Nullable Long timestamp, String source, @Nullable Map<String, String> tags, String defaultSource) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("histogram name cannot be blank");
        }
        if (histogramGranularities == null || histogramGranularities.isEmpty()) {
            throw new IllegalArgumentException("Histogram granularities cannot be null or empty");
        }
        if (centroids == null || centroids.isEmpty()) {
            throw new IllegalArgumentException("A distribution should have at least one centroid");
        }
        if (source == null || source.isEmpty()) {
            source = defaultSource;
        }
        StringBuilder sb = new StringBuilder();
        for (HistogramGranularity histogramGranularity : histogramGranularities) {
            sb.append(histogramGranularity.identifier);
            if (timestamp != null) {
                sb.append(' ');
                sb.append(Long.toString(timestamp));
            }
            for (Pair<Double, Integer> pair : centroids) {
                sb.append(" #");
                sb.append(pair._2);
                sb.append(' ');
                sb.append(pair._1);
            }
            sb.append(' ');
            sb.append(Utils.sanitize(name));
            sb.append(" source=");
            sb.append(Utils.sanitize(source));
            if (tags != null) {
                for (Map.Entry entry : tags.entrySet()) {
                    String key = (String)entry.getKey();
                    String val = (String)entry.getValue();
                    if (key == null || key.isEmpty()) {
                        throw new IllegalArgumentException("histogram tag key cannot be blank");
                    }
                    if (val == null || val.isEmpty()) {
                        throw new IllegalArgumentException("histogram tag value cannot be blank for tag key: " + key);
                    }
                    sb.append(' ');
                    sb.append(Utils.sanitize((String)entry.getKey()));
                    sb.append('=');
                    sb.append(Utils.sanitizeValue((String)entry.getValue()));
                }
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    public static String tracingSpanToLineData(String name, long startMillis, long durationMillis, String source, UUID traceId, UUID spanId, @Nullable List<UUID> parents, @Nullable List<UUID> followsFrom, @Nullable List<Pair<String, String>> tags, @Nullable List<SpanLog> spanLogs, String defaultSource) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("span name cannot be blank");
        }
        if (source == null || source.isEmpty()) {
            source = defaultSource;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(Utils.sanitizeValue(name));
        sb.append(" source=");
        sb.append(Utils.sanitize(source));
        sb.append(" traceId=");
        sb.append(traceId);
        sb.append(" spanId=");
        sb.append(spanId);
        if (parents != null) {
            for (UUID uUID : parents) {
                sb.append(" parent=");
                sb.append(uUID.toString());
            }
        }
        if (followsFrom != null) {
            for (UUID uUID : followsFrom) {
                sb.append(" followsFrom=");
                sb.append(uUID.toString());
            }
        }
        if (tags != null) {
            for (Pair pair : tags) {
                String key = (String)pair._1;
                String val = (String)pair._2;
                if (key == null || key.isEmpty()) {
                    throw new IllegalArgumentException("span tag key cannot be blank");
                }
                if (val == null || val.isEmpty()) {
                    throw new IllegalArgumentException("span tag value cannot be blank for tag key: " + key);
                }
                sb.append(' ');
                sb.append(Utils.sanitize(key));
                sb.append('=');
                sb.append(Utils.sanitizeValue(val));
            }
        }
        if (spanLogs != null && !spanLogs.isEmpty()) {
            sb.append(' ');
            sb.append(Utils.sanitize("_spanLogs"));
            sb.append('=');
            sb.append(Utils.sanitize("true"));
        }
        sb.append(' ');
        sb.append(startMillis);
        sb.append(' ');
        sb.append(durationMillis);
        sb.append('\n');
        return sb.toString();
    }

    public static String spanLogsToLineData(UUID traceId, UUID spanId, @NonNull List<SpanLog> spanLogs) throws JsonProcessingException {
        StringBuilder toReturn = new StringBuilder();
        toReturn.append(JSON_PARSER.writeValueAsString((Object)new SpanLogsDTO(traceId, spanId, spanLogs)));
        toReturn.append("\n");
        return toReturn.toString();
    }

    public static void shutdownExecutorAndWait(ExecutorService tpe) {
        tpe.shutdown();
        try {
            if (!tpe.awaitTermination(60L, TimeUnit.SECONDS)) {
                tpe.shutdownNow();
                if (!tpe.awaitTermination(60L, TimeUnit.SECONDS)) {
                    logger.log(Level.FINE, "pool did not terminate");
                }
            }
        }
        catch (InterruptedException ie) {
            tpe.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    private static String sanitizeInternal(String s, boolean addQuotes) {
        StringBuilder sb = new StringBuilder();
        if (addQuotes) {
            sb.append('\"');
        }
        for (int i = 0; i < s.length(); ++i) {
            char cur = s.charAt(i);
            boolean isLegal = true;
            if (!(',' <= cur && cur <= '9' || 'A' <= cur && cur <= 'Z' || 'a' <= cur && cur <= 'z' || cur == '_' || i == 0 && cur == '\u2206' || i == 0 && cur == '\u0394' || i == 0 && cur == '~')) {
                isLegal = false;
            }
            if (cur == '/') {
                isLegal = false;
            }
            sb.append(isLegal ? cur : (char)'-');
        }
        if (addQuotes) {
            sb.append('\"');
        }
        return sb.toString();
    }
}

