/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.sdk.proxy;

import com.wavefront.sdk.common.NamedThreadFactory;
import com.wavefront.sdk.common.Pair;
import com.wavefront.sdk.common.Utils;
import com.wavefront.sdk.common.WavefrontSender;
import com.wavefront.sdk.common.annotation.Nullable;
import com.wavefront.sdk.common.metrics.WavefrontSdkCounter;
import com.wavefront.sdk.common.metrics.WavefrontSdkMetricsRegistry;
import com.wavefront.sdk.entities.histograms.HistogramGranularity;
import com.wavefront.sdk.entities.tracing.SpanLog;
import com.wavefront.sdk.proxy.ProxyConnectionHandler;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.SocketFactory;

public class WavefrontProxyClient
implements WavefrontSender,
Runnable {
    private static final Logger logger = Logger.getLogger(WavefrontProxyClient.class.getCanonicalName());
    @Nullable
    private final ProxyConnectionHandler metricsProxyConnectionHandler;
    @Nullable
    private final ProxyConnectionHandler histogramProxyConnectionHandler;
    @Nullable
    private final ProxyConnectionHandler tracingProxyConnectionHandler;
    private final String defaultSource;
    private final ScheduledExecutorService scheduler;
    private final WavefrontSdkMetricsRegistry sdkMetricsRegistry;
    private final WavefrontSdkCounter pointsDiscarded;
    private final WavefrontSdkCounter pointsValid;
    private final WavefrontSdkCounter pointsInvalid;
    private final WavefrontSdkCounter pointsDropped;
    private final WavefrontSdkCounter histogramsDiscarded;
    private final WavefrontSdkCounter histogramsValid;
    private final WavefrontSdkCounter histogramsInvalid;
    private final WavefrontSdkCounter histogramsDropped;
    private final WavefrontSdkCounter spansDiscarded;
    private final WavefrontSdkCounter spansValid;
    private final WavefrontSdkCounter spansInvalid;
    private final WavefrontSdkCounter spansDropped;

    private WavefrontProxyClient(Builder builder) {
        String tempSource = "unknown";
        try {
            tempSource = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ex) {
            logger.log(Level.WARNING, "Unable to resolve local host name. Source will default to 'unknown'", ex);
        }
        this.defaultSource = tempSource;
        this.sdkMetricsRegistry = new WavefrontSdkMetricsRegistry.Builder(this).prefix("~sdk.java.core.sender.proxy").build();
        this.metricsProxyConnectionHandler = builder.metricsPort == null ? null : new ProxyConnectionHandler(new InetSocketAddress(builder.proxyHostName, (int)builder.metricsPort), builder.socketFactory, this.sdkMetricsRegistry, "metricHandler");
        this.histogramProxyConnectionHandler = builder.distributionPort == null ? null : new ProxyConnectionHandler(new InetSocketAddress(builder.proxyHostName, (int)builder.distributionPort), builder.socketFactory, this.sdkMetricsRegistry, "histogramHandler");
        this.tracingProxyConnectionHandler = builder.tracingPort == null ? null : new ProxyConnectionHandler(new InetSocketAddress(builder.proxyHostName, (int)builder.tracingPort), builder.socketFactory, this.sdkMetricsRegistry, "tracingHandler");
        this.scheduler = Executors.newScheduledThreadPool(1, new NamedThreadFactory("wavefrontProxySender"));
        this.scheduler.scheduleAtFixedRate(this, 1L, builder.flushIntervalSeconds, TimeUnit.SECONDS);
        this.pointsDiscarded = this.sdkMetricsRegistry.newCounter("points.discarded");
        this.pointsValid = this.sdkMetricsRegistry.newCounter("points.valid");
        this.pointsInvalid = this.sdkMetricsRegistry.newCounter("points.invalid");
        this.pointsDropped = this.sdkMetricsRegistry.newCounter("points.dropped");
        this.histogramsDiscarded = this.sdkMetricsRegistry.newCounter("histograms.discarded");
        this.histogramsValid = this.sdkMetricsRegistry.newCounter("histograms.valid");
        this.histogramsInvalid = this.sdkMetricsRegistry.newCounter("histograms.invalid");
        this.histogramsDropped = this.sdkMetricsRegistry.newCounter("histograms.dropped");
        this.spansDiscarded = this.sdkMetricsRegistry.newCounter("spans.discarded");
        this.spansValid = this.sdkMetricsRegistry.newCounter("spans.valid");
        this.spansInvalid = this.sdkMetricsRegistry.newCounter("spans.invalid");
        this.spansDropped = this.sdkMetricsRegistry.newCounter("spans.dropped");
    }

    @Override
    public void sendMetric(String name, double value, @Nullable Long timestamp, @Nullable String source, @Nullable Map<String, String> tags) throws IOException {
        String lineData;
        if (this.metricsProxyConnectionHandler == null) {
            this.pointsDiscarded.inc();
            logger.warning("Can't send data to Wavefront. Please configure metrics port for Wavefront proxy");
            return;
        }
        try {
            lineData = Utils.metricToLineData(name, value, timestamp, source, tags, this.defaultSource);
            this.pointsValid.inc();
        }
        catch (IllegalArgumentException e) {
            this.pointsInvalid.inc();
            throw e;
        }
        try {
            this.metricsProxyConnectionHandler.sendData(lineData);
        }
        catch (Exception e) {
            this.pointsDropped.inc();
            this.metricsProxyConnectionHandler.incrementFailureCount();
            throw new IOException(e);
        }
    }

    @Override
    public void sendFormattedMetric(String point) throws IOException {
        if (this.metricsProxyConnectionHandler == null) {
            this.pointsDiscarded.inc();
            logger.warning("Can't send data to Wavefront. Please configure metrics port for Wavefront proxy");
            return;
        }
        if (point == null || "".equals(point.trim())) {
            this.pointsInvalid.inc();
            throw new IllegalArgumentException("point must be non-null and in WF data format");
        }
        this.pointsValid.inc();
        String finalPoint = point.endsWith("\n") ? point : point + "\n";
        try {
            this.metricsProxyConnectionHandler.sendData(finalPoint);
        }
        catch (Exception e) {
            this.pointsDropped.inc();
            this.metricsProxyConnectionHandler.incrementFailureCount();
            throw new IOException(e);
        }
    }

    @Override
    public void sendDistribution(String name, List<Pair<Double, Integer>> centroids, Set<HistogramGranularity> histogramGranularities, @Nullable Long timestamp, @Nullable String source, @Nullable Map<String, String> tags) throws IOException {
        String lineData;
        if (this.histogramProxyConnectionHandler == null) {
            this.histogramsDiscarded.inc();
            logger.warning("Can't send data to Wavefront. Please configure histogram distribution port for Wavefront proxy");
            return;
        }
        try {
            lineData = Utils.histogramToLineData(name, centroids, histogramGranularities, timestamp, source, tags, this.defaultSource);
            this.histogramsValid.inc();
        }
        catch (IllegalArgumentException e) {
            this.histogramsInvalid.inc();
            throw e;
        }
        try {
            this.histogramProxyConnectionHandler.sendData(lineData);
        }
        catch (Exception e) {
            this.histogramsDropped.inc();
            this.histogramProxyConnectionHandler.incrementFailureCount();
            throw new IOException(e);
        }
    }

    @Override
    public void sendSpan(String name, long startMillis, long durationMillis, @Nullable String source, UUID traceId, UUID spanId, @Nullable List<UUID> parents, @Nullable List<UUID> followsFrom, @Nullable List<Pair<String, String>> tags, @Nullable List<SpanLog> spanLogs) throws IOException {
        String lineData;
        if (this.tracingProxyConnectionHandler == null) {
            this.spansDiscarded.inc();
            logger.warning("Can't send data to Wavefront. Please configure tracing port for Wavefront proxy");
            return;
        }
        try {
            lineData = Utils.tracingSpanToLineData(name, startMillis, durationMillis, source, traceId, spanId, parents, followsFrom, tags, spanLogs, this.defaultSource);
            this.spansValid.inc();
        }
        catch (IllegalArgumentException e) {
            this.spansInvalid.inc();
            throw e;
        }
        try {
            this.tracingProxyConnectionHandler.sendData(lineData);
        }
        catch (Exception e) {
            this.spansDropped.inc();
            this.tracingProxyConnectionHandler.incrementFailureCount();
            throw new IOException(e);
        }
    }

    @Override
    public void run() {
        try {
            this.flush();
        }
        catch (Throwable ex) {
            logger.log(Level.WARNING, "Unable to report to Wavefront cluster", ex);
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.metricsProxyConnectionHandler != null) {
            this.metricsProxyConnectionHandler.flush();
        }
        if (this.histogramProxyConnectionHandler != null) {
            this.histogramProxyConnectionHandler.flush();
        }
        if (this.tracingProxyConnectionHandler != null) {
            this.tracingProxyConnectionHandler.flush();
        }
    }

    @Override
    public int getFailureCount() {
        int failureCount = 0;
        if (this.metricsProxyConnectionHandler != null) {
            failureCount += this.metricsProxyConnectionHandler.getFailureCount();
        }
        if (this.histogramProxyConnectionHandler != null) {
            failureCount += this.histogramProxyConnectionHandler.getFailureCount();
        }
        if (this.tracingProxyConnectionHandler != null) {
            failureCount += this.tracingProxyConnectionHandler.getFailureCount();
        }
        return failureCount;
    }

    @Override
    public void close() {
        this.sdkMetricsRegistry.close();
        try {
            this.flush();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "error flushing buffer", e);
        }
        try {
            this.scheduler.shutdownNow();
        }
        catch (SecurityException ex) {
            logger.log(Level.FINE, "shutdown error", ex);
        }
        if (this.metricsProxyConnectionHandler != null) {
            try {
                this.metricsProxyConnectionHandler.close();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "error closing metricsProxyConnectionHandler", e);
            }
        }
        if (this.histogramProxyConnectionHandler != null) {
            try {
                this.histogramProxyConnectionHandler.close();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "error closing histogramProxyConnectionHandler", e);
            }
        }
        if (this.tracingProxyConnectionHandler != null) {
            try {
                this.tracingProxyConnectionHandler.close();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "error closing tracingProxyConnectionHandler", e);
            }
        }
    }

    public static class Builder {
        private final String proxyHostName;
        private Integer metricsPort;
        private Integer distributionPort;
        private Integer tracingPort;
        private SocketFactory socketFactory = SocketFactory.getDefault();
        private int flushIntervalSeconds = 5;

        public Builder(String proxyHostName) {
            this.proxyHostName = proxyHostName;
        }

        public Builder metricsPort(int metricsPort) {
            this.metricsPort = metricsPort;
            return this;
        }

        public Builder distributionPort(int distributionPort) {
            this.distributionPort = distributionPort;
            return this;
        }

        public Builder tracingPort(int tracingPort) {
            this.tracingPort = tracingPort;
            return this;
        }

        public Builder socketFactory(SocketFactory socketFactory) {
            this.socketFactory = socketFactory;
            return this;
        }

        public Builder flushIntervalSeconds(int flushIntervalSeconds) {
            this.flushIntervalSeconds = flushIntervalSeconds;
            return this;
        }

        public WavefrontProxyClient build() {
            return new WavefrontProxyClient(this);
        }
    }
}

