/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.sdk.common;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.wavefront.sdk.common.Pair;
import com.wavefront.sdk.common.annotation.NonNull;
import com.wavefront.sdk.common.annotation.Nullable;
import com.wavefront.sdk.entities.histograms.HistogramGranularity;
import com.wavefront.sdk.entities.tracing.SpanLog;
import com.wavefront.sdk.entities.tracing.SpanLogsDTO;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;

public class Utils {
    private static final Pattern WHITESPACE = Pattern.compile("[\\s]+");
    private static final ObjectMapper JSON_PARSER = new ObjectMapper();

    public static String sanitize(String s) {
        String whitespaceSanitized = WHITESPACE.matcher(s).replaceAll("-");
        if (s.contains("\"") || s.contains("'")) {
            return "\"" + whitespaceSanitized.replaceAll("\"", "\\\\\"") + "\"";
        }
        return "\"" + whitespaceSanitized + "\"";
    }

    public static String metricToLineData(String name, double value, @Nullable Long timestamp, String source, @Nullable Map<String, String> tags, String defaultSource) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("metrics name cannot be blank");
        }
        if (source == null || source.isEmpty()) {
            source = defaultSource;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(Utils.sanitize(name));
        sb.append(' ');
        sb.append(value);
        if (timestamp != null) {
            sb.append(' ');
            sb.append(timestamp);
        }
        sb.append(" source=");
        sb.append(Utils.sanitize(source));
        if (tags != null) {
            for (Map.Entry<String, String> tag : tags.entrySet()) {
                String key = tag.getKey();
                String val = tag.getValue();
                if (key == null || key.isEmpty()) {
                    throw new IllegalArgumentException("metric point tag key cannot be blank");
                }
                if (val == null || val.isEmpty()) {
                    throw new IllegalArgumentException("metric point tag value cannot be blank for tag key: " + key);
                }
                sb.append(' ');
                sb.append(Utils.sanitize(key));
                sb.append('=');
                sb.append(Utils.sanitize(val));
            }
        }
        sb.append('\n');
        return sb.toString();
    }

    public static String histogramToLineData(String name, List<Pair<Double, Integer>> centroids, Set<HistogramGranularity> histogramGranularities, @Nullable Long timestamp, String source, @Nullable Map<String, String> tags, String defaultSource) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("histogram name cannot be blank");
        }
        if (histogramGranularities == null || histogramGranularities.isEmpty()) {
            throw new IllegalArgumentException("Histogram granularities cannot be null or empty");
        }
        if (centroids == null || centroids.isEmpty()) {
            throw new IllegalArgumentException("A distribution should have at least one centroid");
        }
        if (source == null || source.isEmpty()) {
            source = defaultSource;
        }
        StringBuilder sb = new StringBuilder();
        for (HistogramGranularity histogramGranularity : histogramGranularities) {
            sb.append(histogramGranularity.identifier);
            if (timestamp != null) {
                sb.append(' ');
                sb.append(Long.toString(timestamp));
            }
            for (Pair<Double, Integer> pair : centroids) {
                sb.append(" #");
                sb.append(pair._2);
                sb.append(' ');
                sb.append(pair._1);
            }
            sb.append(' ');
            sb.append(Utils.sanitize(name));
            sb.append(" source=");
            sb.append(Utils.sanitize(source));
            if (tags != null) {
                for (Map.Entry entry : tags.entrySet()) {
                    String key = (String)entry.getKey();
                    String val = (String)entry.getValue();
                    if (key == null || key.isEmpty()) {
                        throw new IllegalArgumentException("histogram tag key cannot be blank");
                    }
                    if (val == null || val.isEmpty()) {
                        throw new IllegalArgumentException("histogram tag value cannot be blank for tag key: " + key);
                    }
                    sb.append(' ');
                    sb.append(Utils.sanitize((String)entry.getKey()));
                    sb.append('=');
                    sb.append(Utils.sanitize((String)entry.getValue()));
                }
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    public static String tracingSpanToLineData(String name, long startMillis, long durationMillis, String source, UUID traceId, UUID spanId, @Nullable List<UUID> parents, @Nullable List<UUID> followsFrom, @Nullable List<Pair<String, String>> tags, @Nullable List<SpanLog> spanLogs, String defaultSource) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("span name cannot be blank");
        }
        if (source == null || source.isEmpty()) {
            source = defaultSource;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(Utils.sanitize(name));
        sb.append(" source=");
        sb.append(Utils.sanitize(source));
        sb.append(" traceId=");
        sb.append(traceId);
        sb.append(" spanId=");
        sb.append(spanId);
        if (parents != null) {
            for (UUID uUID : parents) {
                sb.append(" parent=");
                sb.append(uUID.toString());
            }
        }
        if (followsFrom != null) {
            for (UUID uUID : followsFrom) {
                sb.append(" followsFrom=");
                sb.append(uUID.toString());
            }
        }
        if (tags != null) {
            for (Pair pair : tags) {
                String key = (String)pair._1;
                String val = (String)pair._2;
                if (key == null || key.isEmpty()) {
                    throw new IllegalArgumentException("span tag key cannot be blank");
                }
                if (val == null || val.isEmpty()) {
                    throw new IllegalArgumentException("span tag value cannot be blank for tag key: " + key);
                }
                sb.append(' ');
                sb.append(Utils.sanitize(key));
                sb.append('=');
                sb.append(Utils.sanitize(val));
            }
        }
        if (spanLogs != null && !spanLogs.isEmpty()) {
            sb.append(' ');
            sb.append(Utils.sanitize("_spanLogs"));
            sb.append('=');
            sb.append(Utils.sanitize("true"));
        }
        sb.append(' ');
        sb.append(startMillis);
        sb.append(' ');
        sb.append(durationMillis);
        sb.append('\n');
        return sb.toString();
    }

    public static String spanLogsToLineData(UUID traceId, UUID spanId, @NonNull List<SpanLog> spanLogs) throws JsonProcessingException {
        StringBuilder toReturn = new StringBuilder();
        toReturn.append(JSON_PARSER.writeValueAsString((Object)new SpanLogsDTO(traceId, spanId, spanLogs)));
        toReturn.append("\n");
        return toReturn.toString();
    }
}

