/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.java_sdk.com.tdunning.math.stats;

public class Sort {
    public static void sort(int[] order, double[] values) {
        Sort.sort(order, values, values.length);
    }

    public static void sort(int[] order, double[] values, int n) {
        for (int i = 0; i < n; ++i) {
            order[i] = i;
        }
        Sort.quickSort(order, values, 0, n, 8);
        Sort.insertionSort(order, values, n, 8);
    }

    private static void quickSort(int[] order, double[] values, int start, int end, int limit) {
        while (end - start > limit) {
            double pivotValue;
            int pivotIndex;
            int a = start;
            int b = (start + end) / 2;
            int c = end - 1;
            double va = values[order[a]];
            double vb = values[order[b]];
            double vc = values[order[c]];
            if (va > vb) {
                if (vc > va) {
                    pivotIndex = a;
                    pivotValue = va;
                } else if (vc < vb) {
                    pivotIndex = b;
                    pivotValue = vb;
                } else {
                    pivotIndex = c;
                    pivotValue = vc;
                }
            } else if (vc > vb) {
                pivotIndex = b;
                pivotValue = vb;
            } else if (vc < va) {
                pivotIndex = a;
                pivotValue = va;
            } else {
                pivotIndex = c;
                pivotValue = vc;
            }
            Sort.swap(order, start, pivotIndex);
            int low = start + 1;
            int high = end;
            int i = low;
            while (i < high) {
                double vi = values[order[i]];
                if (vi == pivotValue) {
                    if (low != i) {
                        Sort.swap(order, low, i);
                    } else {
                        ++i;
                    }
                    ++low;
                    continue;
                }
                if (vi > pivotValue) {
                    Sort.swap(order, i, --high);
                    continue;
                }
                ++i;
            }
            int from = start;
            int to = high - 1;
            i = 0;
            while (from < low && to >= low) {
                Sort.swap(order, from++, to--);
                ++i;
            }
            if ((low = from == low ? to + 1 : from) - start < end - high) {
                Sort.quickSort(order, values, start, low, limit);
                start = high;
                continue;
            }
            Sort.quickSort(order, values, high, end, limit);
            end = low;
        }
    }

    private static void swap(int[] order, int i, int j) {
        int t = order[i];
        order[i] = order[j];
        order[j] = t;
    }

    public static void checkPartition(int[] order, double[] values, double pivotValue, int start, int low, int high, int end) {
        double v;
        int i;
        if (order.length != values.length) {
            throw new IllegalArgumentException("Arguments must be same size");
        }
        if (start < 0 || low < start || high < low || end < high) {
            throw new IllegalArgumentException(String.format("Invalid indices %d, %d, %d, %d", start, low, high, end));
        }
        for (i = 0; i < low; ++i) {
            v = values[order[i]];
            if (!(v >= pivotValue)) continue;
            throw new IllegalArgumentException(String.format("Value greater than pivot at %d", i));
        }
        for (i = low; i < high; ++i) {
            if (values[order[i]] == pivotValue) continue;
            throw new IllegalArgumentException(String.format("Non-pivot at %d", i));
        }
        for (i = high; i < end; ++i) {
            v = values[order[i]];
            if (!(v <= pivotValue)) continue;
            throw new IllegalArgumentException(String.format("Value less than pivot at %d", i));
        }
    }

    private static void insertionSort(int[] order, double[] values, int n, int limit) {
        block0: for (int i = 1; i < n; ++i) {
            int t = order[i];
            double v = values[order[i]];
            int m = Math.max(i - limit, 0);
            for (int j = i; j >= m; --j) {
                if (j != 0 && !(values[order[j - 1]] <= v)) continue;
                if (j >= i) continue block0;
                System.arraycopy(order, j, order, j + 1, i - j);
                order[j] = t;
                continue block0;
            }
        }
    }
}

