/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.sdk.common.clients;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import com.wavefront.sdk.common.NamedThreadFactory;
import com.wavefront.sdk.common.Pair;
import com.wavefront.sdk.common.Utils;
import com.wavefront.sdk.common.WavefrontSender;
import com.wavefront.sdk.common.annotation.NonNull;
import com.wavefront.sdk.common.annotation.Nullable;
import com.wavefront.sdk.common.clients.service.ReportingService;
import com.wavefront.sdk.common.logging.MessageDedupingLogger;
import com.wavefront.sdk.common.metrics.WavefrontSdkDeltaCounter;
import com.wavefront.sdk.common.metrics.WavefrontSdkMetricsRegistry;
import com.wavefront.sdk.entities.histograms.HistogramGranularity;
import com.wavefront.sdk.entities.tracing.SpanLog;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WavefrontClient
implements WavefrontSender,
Runnable {
    private static final MessageDedupingLogger logger = new MessageDedupingLogger(Logger.getLogger(WavefrontClient.class.getCanonicalName()), LogMessageType.values().length, 0.02);
    private final String defaultSource;
    private final String clientId;
    private final String instanceId = Integer.toHexString((int)(Math.random() * 2.147483647E9));
    private final int batchSize;
    private final int messageSizeBytes;
    private final LinkedBlockingQueue<String> metricsBuffer;
    private final LinkedBlockingQueue<String> histogramsBuffer;
    private final LinkedBlockingQueue<String> tracingSpansBuffer;
    private final LinkedBlockingQueue<String> spanLogsBuffer;
    private final LinkedBlockingQueue<String> eventsBuffer;
    private final LinkedBlockingQueue<String> logsBuffer;
    private final ReportingService metricsReportingService;
    private final ReportingService tracesReportingService;
    private final ScheduledExecutorService scheduler;
    private final WavefrontSdkMetricsRegistry sdkMetricsRegistry;
    private final WavefrontSdkDeltaCounter pointsValid;
    private final WavefrontSdkDeltaCounter pointsInvalid;
    private final WavefrontSdkDeltaCounter pointsDropped;
    private final WavefrontSdkDeltaCounter pointReportErrors;
    private final WavefrontSdkDeltaCounter histogramsValid;
    private final WavefrontSdkDeltaCounter histogramsInvalid;
    private final WavefrontSdkDeltaCounter histogramsDropped;
    private final WavefrontSdkDeltaCounter histogramReportErrors;
    private final WavefrontSdkDeltaCounter spansValid;
    private final WavefrontSdkDeltaCounter spansInvalid;
    private final WavefrontSdkDeltaCounter spansDropped;
    private final WavefrontSdkDeltaCounter spanReportErrors;
    private final WavefrontSdkDeltaCounter spanLogsValid;
    private final WavefrontSdkDeltaCounter spanLogsInvalid;
    private final WavefrontSdkDeltaCounter spanLogsDropped;
    private final WavefrontSdkDeltaCounter spanLogReportErrors;
    private final WavefrontSdkDeltaCounter logsValid;
    private final WavefrontSdkDeltaCounter logsInvalid;
    private final WavefrontSdkDeltaCounter logsDropped;
    private final WavefrontSdkDeltaCounter logsReportErrors;
    private final WavefrontSdkDeltaCounter eventsValid;
    private final WavefrontSdkDeltaCounter eventsInvalid;
    private final WavefrontSdkDeltaCounter eventsDropped;
    private final WavefrontSdkDeltaCounter eventsReportErrors;
    private final AtomicInteger metricsDisabledStatusCode;
    private final AtomicInteger histogramsDisabledStatusCode;
    private final AtomicInteger spansDisabledStatusCode;
    private final AtomicInteger spanLogsDisabledStatusCode;
    private final AtomicInteger eventsDisabledStatusCode;
    private final AtomicInteger logsDisabledStatusCode;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    private WavefrontClient(Builder builder) {
        String tempSource = "unknown";
        try {
            tempSource = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ex) {
            logger.log(LogMessageType.UNKNOWN_HOST.toString(), Level.WARNING, "Unable to resolve local host name. Source will default to 'unknown'");
        }
        this.defaultSource = tempSource;
        this.batchSize = builder.batchSize;
        this.messageSizeBytes = builder.messageSizeBytes;
        this.metricsBuffer = new LinkedBlockingQueue(builder.maxQueueSize);
        this.histogramsBuffer = new LinkedBlockingQueue(builder.maxQueueSize);
        this.tracingSpansBuffer = new LinkedBlockingQueue(builder.maxQueueSize);
        this.spanLogsBuffer = new LinkedBlockingQueue(builder.maxQueueSize);
        this.eventsBuffer = new LinkedBlockingQueue(builder.maxQueueSize);
        this.logsBuffer = new LinkedBlockingQueue(builder.maxQueueSize);
        this.metricsReportingService = new ReportingService(builder.metricsUri, builder.token, builder.reportingServiceLogSuppressTimeSeconds);
        this.tracesReportingService = new ReportingService(builder.tracesUri, builder.token, builder.reportingServiceLogSuppressTimeSeconds);
        this.scheduler = Executors.newScheduledThreadPool(1, new NamedThreadFactory("wavefrontClientSender").setDaemon(true));
        this.scheduler.scheduleAtFixedRate(this, 1L, builder.flushInterval, builder.flushIntervalTimeUnit);
        String processId = ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
        this.sdkMetricsRegistry = new WavefrontSdkMetricsRegistry.Builder(this).prefix("~sdk.java.core.sender.wfclient").tag("pid", processId).tag("instanceId", this.instanceId).tags(builder.tags).sendSdkMetrics(builder.includeSdkMetrics).build();
        double sdkVersion = Utils.getSemVerGauge("wavefront-sdk-java");
        this.sdkMetricsRegistry.newGauge("version", () -> sdkVersion);
        this.sdkMetricsRegistry.newGauge("points.queue.size", this.metricsBuffer::size);
        this.sdkMetricsRegistry.newGauge("points.queue.remaining_capacity", this.metricsBuffer::remainingCapacity);
        this.pointsValid = this.sdkMetricsRegistry.newDeltaCounter("points.valid");
        this.pointsInvalid = this.sdkMetricsRegistry.newDeltaCounter("points.invalid");
        this.pointsDropped = this.sdkMetricsRegistry.newDeltaCounter("points.dropped");
        this.pointReportErrors = this.sdkMetricsRegistry.newDeltaCounter("points.report.errors");
        this.sdkMetricsRegistry.newGauge("histograms.queue.size", this.histogramsBuffer::size);
        this.sdkMetricsRegistry.newGauge("histograms.queue.remaining_capacity", this.histogramsBuffer::remainingCapacity);
        this.histogramsValid = this.sdkMetricsRegistry.newDeltaCounter("histograms.valid");
        this.histogramsInvalid = this.sdkMetricsRegistry.newDeltaCounter("histograms.invalid");
        this.histogramsDropped = this.sdkMetricsRegistry.newDeltaCounter("histograms.dropped");
        this.histogramReportErrors = this.sdkMetricsRegistry.newDeltaCounter("histograms.report.errors");
        this.sdkMetricsRegistry.newGauge("spans.queue.size", this.tracingSpansBuffer::size);
        this.sdkMetricsRegistry.newGauge("spans.queue.remaining_capacity", this.tracingSpansBuffer::remainingCapacity);
        this.spansValid = this.sdkMetricsRegistry.newDeltaCounter("spans.valid");
        this.spansInvalid = this.sdkMetricsRegistry.newDeltaCounter("spans.invalid");
        this.spansDropped = this.sdkMetricsRegistry.newDeltaCounter("spans.dropped");
        this.spanReportErrors = this.sdkMetricsRegistry.newDeltaCounter("spans.report.errors");
        this.sdkMetricsRegistry.newGauge("span_logs.queue.size", this.spanLogsBuffer::size);
        this.sdkMetricsRegistry.newGauge("span_logs.queue.remaining_capacity", this.spanLogsBuffer::remainingCapacity);
        this.spanLogsValid = this.sdkMetricsRegistry.newDeltaCounter("span_logs.valid");
        this.spanLogsInvalid = this.sdkMetricsRegistry.newDeltaCounter("span_logs.invalid");
        this.spanLogsDropped = this.sdkMetricsRegistry.newDeltaCounter("span_logs.dropped");
        this.spanLogReportErrors = this.sdkMetricsRegistry.newDeltaCounter("span_logs.report.errors");
        this.logsValid = this.sdkMetricsRegistry.newDeltaCounter("logs.valid");
        this.logsInvalid = this.sdkMetricsRegistry.newDeltaCounter("logs.invalid");
        this.logsDropped = this.sdkMetricsRegistry.newDeltaCounter("logs.dropped");
        this.logsReportErrors = this.sdkMetricsRegistry.newDeltaCounter("logs.report.errors");
        this.sdkMetricsRegistry.newGauge("events.queue.size", this.eventsBuffer::size);
        this.sdkMetricsRegistry.newGauge("events.queue.remaining_capacity", this.eventsBuffer::remainingCapacity);
        this.eventsValid = this.sdkMetricsRegistry.newDeltaCounter("events.valid");
        this.eventsInvalid = this.sdkMetricsRegistry.newDeltaCounter("events.invalid");
        this.eventsDropped = this.sdkMetricsRegistry.newDeltaCounter("events.dropped");
        this.eventsReportErrors = this.sdkMetricsRegistry.newDeltaCounter("events.report.errors");
        this.metricsDisabledStatusCode = new AtomicInteger();
        this.histogramsDisabledStatusCode = new AtomicInteger();
        this.spansDisabledStatusCode = new AtomicInteger();
        this.spanLogsDisabledStatusCode = new AtomicInteger();
        this.eventsDisabledStatusCode = new AtomicInteger();
        this.logsDisabledStatusCode = new AtomicInteger();
        this.clientId = builder.server;
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public void sendMetric(String name, double value, @Nullable Long timestamp, @Nullable String source, @Nullable Map<String, String> tags) throws IOException {
        String point;
        if (this.closed.get()) {
            throw new IOException("attempt to send using closed sender");
        }
        try {
            point = Utils.metricToLineData(name, value, timestamp, source, tags, this.defaultSource);
            this.pointsValid.inc();
            logger.fine("sendMetric: " + point);
        }
        catch (IllegalArgumentException e) {
            this.pointsInvalid.inc();
            throw e;
        }
        if (!this.metricsBuffer.offer(point)) {
            this.pointsDropped.inc();
            logger.log(LogMessageType.METRICS_BUFFER_FULL.toString(), Level.WARNING, "Buffer full, dropping metric point: " + point + ". Consider increasing the batch size of your sender to increase throughput.");
        }
    }

    @Override
    public void sendFormattedMetric(String point) throws IOException {
        String finalPoint;
        if (this.closed.get()) {
            throw new IOException("attempt to send using closed sender");
        }
        if (point == null || "".equals(point.trim())) {
            this.pointsInvalid.inc();
            throw new IllegalArgumentException("point must be non-null and in WF data format");
        }
        this.pointsValid.inc();
        logger.fine("sendFormattedMetric: " + point);
        String string = finalPoint = point.endsWith("\n") ? point : point + "\n";
        if (!this.metricsBuffer.offer(finalPoint)) {
            this.pointsDropped.inc();
            logger.log(LogMessageType.METRICS_BUFFER_FULL.toString(), Level.WARNING, "Buffer full, dropping metric point: " + finalPoint + ". Consider increasing the batch size of your sender to increase throughput.");
        }
    }

    @Override
    public void sendDistribution(String name, List<Pair<Double, Integer>> centroids, Set<HistogramGranularity> histogramGranularities, @Nullable Long timestamp, @Nullable String source, @Nullable Map<String, String> tags) throws IOException {
        String histograms;
        if (this.closed.get()) {
            throw new IOException("attempt to send using closed sender");
        }
        try {
            histograms = Utils.histogramToLineData(name, centroids, histogramGranularities, timestamp, source, tags, this.defaultSource);
            this.histogramsValid.inc();
            logger.fine("sendDistribution: " + histograms);
        }
        catch (IllegalArgumentException e) {
            this.histogramsInvalid.inc();
            throw e;
        }
        if (!this.histogramsBuffer.offer(histograms)) {
            this.histogramsDropped.inc();
            logger.log(LogMessageType.HISTOGRAMS_BUFFER_FULL.toString(), Level.WARNING, "Buffer full, dropping histograms: " + histograms + ". Consider increasing the batch size of your sender to increase throughput.");
        }
    }

    @Override
    public void sendLog(String name, double value, Long timestamp, String source, Map<String, String> tags) throws IOException {
        String point;
        if (this.closed.get()) {
            throw new IOException("attempt to send using closed sender");
        }
        try {
            point = Utils.logToLineData(name, value, timestamp, source, tags, this.defaultSource);
            this.logsValid.inc();
            logger.fine("sendLog: " + point);
        }
        catch (IllegalArgumentException e) {
            this.logsInvalid.inc();
            throw e;
        }
        if (!this.logsBuffer.offer(point)) {
            this.logsDropped.inc();
            logger.log(LogMessageType.LOGS_BUFFER_FULL.toString(), Level.WARNING, "Buffer full, dropping log point: " + point + ". Consider increasing the batch size of your sender to increase throughput.");
        }
    }

    @Override
    public void sendEvent(String name, long startMillis, long endMillis, @Nullable String source, @Nullable Map<String, String> tags, @Nullable Map<String, String> annotations) throws IOException {
        String event;
        if (this.closed.get()) {
            throw new IOException("attempt to send using closed sender");
        }
        URI uri = URI.create(this.clientId);
        try {
            event = uri.getScheme().equals("http") ? Utils.eventToLineData(name, startMillis, endMillis, source, tags, annotations, this.defaultSource, false) : Utils.eventToLineData(name, startMillis, endMillis, source, tags, annotations, this.defaultSource, true);
            this.eventsValid.inc();
            logger.fine("sendEvent: " + event);
        }
        catch (IllegalArgumentException e) {
            this.eventsInvalid.inc();
            throw e;
        }
        if (!this.eventsBuffer.offer(event)) {
            this.eventsDropped.inc();
            logger.log(LogMessageType.EVENTS_BUFFER_FULL.toString(), Level.WARNING, "Buffer full, dropping events: " + event + ".");
        }
    }

    @Override
    public void sendSpan(String name, long startMillis, long durationMillis, @Nullable String source, UUID traceId, UUID spanId, @Nullable List<UUID> parents, @Nullable List<UUID> followsFrom, @Nullable List<Pair<String, String>> tags, @Nullable List<SpanLog> spanLogs) throws IOException {
        String span;
        if (this.closed.get()) {
            throw new IOException("attempt to send using closed sender");
        }
        try {
            span = Utils.tracingSpanToLineData(name, startMillis, durationMillis, source, traceId, spanId, parents, followsFrom, tags, spanLogs, this.defaultSource);
            this.spansValid.inc();
            logger.fine("sendSpan: " + span);
        }
        catch (IllegalArgumentException e) {
            this.spansInvalid.inc();
            throw e;
        }
        if (this.tracingSpansBuffer.offer(span)) {
            if (spanLogs != null && !spanLogs.isEmpty()) {
                String spanSecondaryId = null;
                if (tags != null) {
                    spanSecondaryId = tags.stream().filter(pair -> ((String)pair._1).equals("_spanSecondaryId")).map(pair -> (String)pair._2).findFirst().orElse(null);
                }
                this.sendSpanLogs(traceId, spanId, spanLogs, span, spanSecondaryId);
            }
        } else {
            this.spansDropped.inc();
            if (spanLogs != null && !spanLogs.isEmpty()) {
                this.spanLogsDropped.inc();
            }
            logger.log(LogMessageType.SPANS_BUFFER_FULL.toString(), Level.WARNING, "Buffer full, dropping span: " + span + ". Consider increasing the batch size of your sender to increase throughput.");
        }
    }

    private void sendSpanLogs(UUID traceId, UUID spanId, List<SpanLog> spanLogs, String span, @Nullable String spanSecondaryId) {
        try {
            String spanLogsJson = Utils.spanLogsToLineData(traceId, spanId, spanLogs, span, spanSecondaryId);
            this.spanLogsValid.inc();
            logger.fine("sendSpanLogs: " + spanLogsJson);
            if (!this.spanLogsBuffer.offer(spanLogsJson)) {
                this.spanLogsDropped.inc();
                logger.log(LogMessageType.SPANLOGS_BUFFER_FULL.toString(), Level.WARNING, "Buffer full, dropping spanLogs: " + spanLogsJson + ". Consider increasing the batch size of your sender to increase throughput.");
            }
        }
        catch (JsonProcessingException e) {
            this.spanLogsInvalid.inc();
            logger.log(LogMessageType.SPANLOGS_PROCESSING_ERROR.toString(), Level.WARNING, "Unable to serialize span logs to JSON: traceId=" + traceId + " spanId=" + spanId + " spanLogs=" + spanLogs);
        }
    }

    @Override
    public void run() {
        try {
            this.flush();
        }
        catch (Throwable ex) {
            logger.log(LogMessageType.FLUSH_ERROR.toString(), Level.WARNING, "Unable to report to Wavefront cluster", Throwables.getRootCause((Throwable)ex));
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.closed.get()) {
            throw new IOException("attempt to flush closed sender");
        }
        this.flushNoCheck();
    }

    private void flushNoCheck() throws IOException {
        this.internalFlush(this.metricsBuffer, "wavefront", "points", "points", this.pointsDropped, this.pointReportErrors, this.metricsDisabledStatusCode, LogMessageType.SEND_METRICS_ERROR, LogMessageType.SEND_METRICS_PERMISSIONS, LogMessageType.METRICS_BUFFER_FULL);
        this.internalFlush(this.histogramsBuffer, "histogram", "histograms", "histograms", this.histogramsDropped, this.histogramReportErrors, this.histogramsDisabledStatusCode, LogMessageType.SEND_HISTOGRAMS_ERROR, LogMessageType.SEND_HISTOGRAMS_PERMISSIONS, LogMessageType.HISTOGRAMS_BUFFER_FULL);
        this.internalFlush(this.tracingSpansBuffer, "trace", "spans", "spans", this.spansDropped, this.spanReportErrors, this.spansDisabledStatusCode, LogMessageType.SEND_SPANS_ERROR, LogMessageType.SEND_SPANS_PERMISSIONS, LogMessageType.SPANS_BUFFER_FULL);
        this.internalFlush(this.spanLogsBuffer, "spanLogs", "span_logs", "span logs", this.spanLogsDropped, this.spanLogReportErrors, this.spanLogsDisabledStatusCode, LogMessageType.SEND_SPANLOGS_ERROR, LogMessageType.SEND_SPANLOGS_PERMISSIONS, LogMessageType.SPANLOGS_BUFFER_FULL);
        this.internalFlush(this.eventsBuffer, "event", "events", "events", this.eventsDropped, this.eventsReportErrors, this.eventsDisabledStatusCode, LogMessageType.SEND_EVENTS_ERROR, LogMessageType.SEND_EVENTS_PERMISSIONS, LogMessageType.EVENTS_BUFFER_FULL);
        this.internalFlush(this.logsBuffer, "log", "logs", "logs", this.logsDropped, this.logsReportErrors, this.logsDisabledStatusCode, LogMessageType.SEND_LOGS_ERROR, LogMessageType.SEND_LOGS_PERMISSIONS, LogMessageType.LOGS_BUFFER_FULL);
    }

    /*
     * Unable to fully structure code
     */
    private void internalFlush(LinkedBlockingQueue<String> buffer, String format, String entityPrefix, String entityType, WavefrontSdkDeltaCounter dropped, WavefrontSdkDeltaCounter reportErrors, AtomicInteger featureDisabledStatusCode, LogMessageType errorMessageType, LogMessageType permissionsMessageType, LogMessageType bufferFullMessageType) throws IOException {
        var12_11 = format;
        var13_12 = -1;
        switch (var12_11.hashCode()) {
            case 2056879129: {
                if (!var12_11.equals("spanLogs")) break;
                var13_12 = 0;
                break;
            }
            case 110620997: {
                if (!var12_11.equals("trace")) break;
                var13_12 = 1;
            }
        }
        switch (var13_12) {
            case 0: 
            case 1: {
                entityReportingService = this.tracesReportingService;
                break;
            }
            default: {
                entityReportingService = this.metricsReportingService;
            }
        }
        batch = null;
        batch = format.equals("event") != false ? WavefrontClient.getBatch(buffer, 1, this.messageSizeBytes, dropped) : WavefrontClient.getBatch(buffer, this.batchSize, this.messageSizeBytes, dropped);
        block26: for (i = 0; i < batch.size(); ++i) {
            items = batch.get(i);
            featureDisabledReason = featureDisabledStatusCode.get();
            if (featureDisabledReason != 0) {
                switch (featureDisabledReason) {
                    case 401: {
                        WavefrontClient.logger.log(permissionsMessageType.toString(), Level.SEVERE, "Please verify that your API Token is correct! All " + entityType + " will be discarded until the service is restarted.");
                        break;
                    }
                    case 403: {
                        if (format.equals("wavefront")) {
                            WavefrontClient.logger.log(permissionsMessageType.toString(), Level.SEVERE, "Please verify that Direct Data Ingestion is enabled for your account! All " + entityType + " will be discarded until the service is restarted.");
                            break;
                        }
                        WavefrontClient.logger.log(permissionsMessageType.toString(), Level.SEVERE, "Please verify that Direct Data Ingestion and " + entityType + " are enabled for your account! All " + entityType + " will be discarded until the service is restarted.");
                    }
                }
                continue;
            }
            try {
                is = this.itemsToStream(items);
                var17_18 = null;
                try {
                    statusCode = format.equals("event") != false ? entityReportingService.sendEvent(is) : entityReportingService.send(format, is);
                    this.sdkMetricsRegistry.newDeltaCounter(entityPrefix + ".report." + statusCode).inc();
                    if ((400 > statusCode || statusCode > 599) && statusCode != -1) continue;
                    switch (statusCode) {
                        case 401: {
                            WavefrontClient.logger.log(permissionsMessageType.toString(), Level.SEVERE, "Error sending " + entityType + " to Wavefront (HTTP " + statusCode + "). Please verify that your API Token is correct! All " + entityType + " will be discarded until the service is restarted.");
                            featureDisabledStatusCode.set(statusCode);
                            dropped.inc(items.size());
                            ** break;
lbl46:
                            // 1 sources

                            continue block26;
                        }
                        case 403: {
                            if (format.equals("wavefront")) {
                                WavefrontClient.logger.log(permissionsMessageType.toString(), Level.SEVERE, "Error sending " + entityType + " to Wavefront (HTTP " + statusCode + "). Please verify that Direct Data Ingestion is enabled for your account! All " + entityType + " will be discarded until the service is restarted.");
                            } else {
                                WavefrontClient.logger.log(permissionsMessageType.toString(), Level.SEVERE, "Error sending " + entityType + " to Wavefront (HTTP " + statusCode + "). Please verify that Direct Data Ingestion and " + entityType + " are enabled for your account! All " + entityType + " will be discarded until the service is restarted.");
                            }
                            featureDisabledStatusCode.set(statusCode);
                            dropped.inc(items.size());
                            ** break;
lbl55:
                            // 1 sources

                            continue block26;
                        }
                        default: {
                            WavefrontClient.logger.log(errorMessageType.toString(), Level.WARNING, "Error sending " + entityType + " to Wavefront (HTTP " + statusCode + "). Data will be requeued and resent.");
                            this.requeue(buffer, items, dropped, entityType, bufferFullMessageType);
                            continue block26;
                        }
                    }
                }
                catch (Throwable var18_22) {
                    var17_18 = var18_22;
                    throw var18_22;
                }
                finally {
                    if (is != null) {
                        if (var17_18 != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable var18_21) {
                                var17_18.addSuppressed(var18_21);
                            }
                        } else {
                            is.close();
                        }
                    }
                }
            }
            catch (IOException ex) {
                dropped.inc(items.size());
                reportErrors.inc();
                for (j = i + 1; j < batch.size(); ++j) {
                    dropped.inc(batch.get(j).size());
                }
                throw ex;
            }
        }
    }

    private void requeue(LinkedBlockingQueue<String> buffer, List<String> items, WavefrontSdkDeltaCounter dropped, String entityType, LogMessageType bufferFullMessageType) {
        int numAddedBackToBuffer = 0;
        for (String item : items) {
            if (buffer.offer(item)) {
                ++numAddedBackToBuffer;
                continue;
            }
            int numDropped = items.size() - numAddedBackToBuffer;
            dropped.inc(numDropped);
            logger.log(bufferFullMessageType.toString(), Level.WARNING, "Buffer full, dropping " + numDropped + " " + entityType + ". Consider increasing the batch size of your sender to increase throughput.");
            break;
        }
    }

    private InputStream itemsToStream(List<String> items) {
        StringBuilder sb = new StringBuilder();
        for (String item : items) {
            sb.append(item);
        }
        return new ByteArrayInputStream(sb.toString().getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public int getFailureCount() {
        return (int)(this.pointReportErrors.count() + this.histogramReportErrors.count() + this.spanReportErrors.count() + this.eventsReportErrors.count());
    }

    @Override
    public synchronized void close() {
        if (!this.closed.compareAndSet(false, true)) {
            logger.log(LogMessageType.CLOSE_WHILE_CLOSED.toString(), Level.FINE, "attempt to close already closed sender");
        }
        try {
            this.flushNoCheck();
        }
        catch (IOException e) {
            logger.log(LogMessageType.FLUSH_ERROR.toString(), Level.WARNING, "error flushing buffer: " + Throwables.getRootCause((Throwable)e));
        }
        this.sdkMetricsRegistry.close();
        try {
            Utils.shutdownExecutorAndWait(this.scheduler);
        }
        catch (SecurityException ex) {
            logger.log(LogMessageType.SHUTDOWN_ERROR.toString(), Level.WARNING, "shutdown error: " + Throwables.getRootCause((Throwable)ex));
        }
    }

    static List<List<String>> getBatch(LinkedBlockingQueue<String> buffer, int batchSize, int messageSizeBytes, WavefrontSdkDeltaCounter dropped) {
        String item;
        batchSize = Math.min(buffer.size(), batchSize);
        ArrayList<List<String>> batch = new ArrayList<List<String>>();
        ArrayList<String> chunk = new ArrayList<String>();
        int numBytesInChunk = 0;
        int count = 0;
        while (count < batchSize && (item = buffer.poll()) != null) {
            int numBytes = item.getBytes(StandardCharsets.UTF_8).length;
            if (numBytes > messageSizeBytes) {
                logger.log(LogMessageType.MESSAGE_SIZE_LIMIT_EXCEEDED.toString(), Level.WARNING, "Dropping data larger than " + messageSizeBytes + " bytes: " + item + ". Consider increasing the message size limit of your sender.");
                dropped.inc();
                continue;
            }
            if (numBytesInChunk + numBytes > messageSizeBytes) {
                if (!chunk.isEmpty()) {
                    batch.add(chunk);
                }
                chunk = new ArrayList();
                numBytesInChunk = 0;
            }
            chunk.add(item);
            numBytesInChunk += numBytes;
            ++count;
        }
        if (!chunk.isEmpty()) {
            batch.add(chunk);
        }
        return batch;
    }

    private static enum LogMessageType {
        UNKNOWN_HOST,
        METRICS_BUFFER_FULL,
        HISTOGRAMS_BUFFER_FULL,
        SPANS_BUFFER_FULL,
        SPANLOGS_BUFFER_FULL,
        EVENTS_BUFFER_FULL,
        LOGS_BUFFER_FULL,
        SPANLOGS_PROCESSING_ERROR,
        FLUSH_ERROR,
        CLOSE_WHILE_CLOSED,
        SEND_METRICS_ERROR,
        SEND_HISTOGRAMS_ERROR,
        SEND_SPANS_ERROR,
        SEND_SPANLOGS_ERROR,
        SEND_EVENTS_ERROR,
        SEND_LOGS_ERROR,
        SEND_METRICS_PERMISSIONS,
        SEND_HISTOGRAMS_PERMISSIONS,
        SEND_SPANS_PERMISSIONS,
        SEND_SPANLOGS_PERMISSIONS,
        SEND_EVENTS_PERMISSIONS,
        SEND_LOGS_PERMISSIONS,
        SHUTDOWN_ERROR,
        MESSAGE_SIZE_LIMIT_EXCEEDED;

    }

    public static class Builder {
        private final String server;
        private final String token;
        private int metricsPort = -1;
        private int tracesPort = -1;
        private int maxQueueSize = 500000;
        private int batchSize = 10000;
        private long reportingServiceLogSuppressTimeSeconds = 300L;
        private long flushInterval = 1L;
        private TimeUnit flushIntervalTimeUnit = TimeUnit.SECONDS;
        private int messageSizeBytes = Integer.MAX_VALUE;
        private boolean includeSdkMetrics = true;
        private Map<String, String> tags = Maps.newHashMap();
        private URI metricsUri;
        private URI tracesUri;

        public Builder(String server, @Nullable String token) {
            this.server = server;
            this.token = token;
        }

        public Builder(String proxyServer) {
            this(proxyServer, null);
        }

        public Builder maxQueueSize(int maxQueueSize) {
            this.maxQueueSize = maxQueueSize;
            return this;
        }

        public Builder batchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public Builder reportingServiceLogSuppressTimeSeconds(long reportingServiceLogSuppressTimeSeconds) {
            this.reportingServiceLogSuppressTimeSeconds = reportingServiceLogSuppressTimeSeconds;
            return this;
        }

        public Builder flushInterval(int flushInterval, @NonNull TimeUnit timeUnit) {
            this.flushInterval = flushInterval;
            this.flushIntervalTimeUnit = timeUnit;
            return this;
        }

        public Builder flushIntervalSeconds(int flushIntervalSeconds) {
            this.flushInterval = flushIntervalSeconds;
            this.flushIntervalTimeUnit = TimeUnit.SECONDS;
            return this;
        }

        public Builder messageSizeBytes(int bytes) {
            this.messageSizeBytes = bytes;
            return this;
        }

        public Builder metricsPort(int port) {
            this.metricsPort = port;
            return this;
        }

        public Builder includeSdkMetrics(boolean includeSdkMetrics) {
            this.includeSdkMetrics = includeSdkMetrics;
            return this;
        }

        public Builder sdkMetricsTags(Map<String, String> tags) {
            this.tags.putAll(tags);
            return this;
        }

        public Builder tracesPort(int port) {
            this.tracesPort = port;
            return this;
        }

        public Builder validateEndpoint() throws IllegalArgumentException {
            URL url = null;
            try {
                url = new URL(this.server);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(this.server + " is not a valid url", e);
            }
            try {
                HttpURLConnection urlConn = (HttpURLConnection)url.openConnection();
                urlConn.connect();
                urlConn.disconnect();
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to connect to " + this.server, e);
            }
            return this;
        }

        public WavefrontClient build() {
            try {
                this.metricsUri = this.buildUri(this.server, this.metricsPort);
                this.tracesUri = this.buildUri(this.server, this.tracesPort);
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException(e);
            }
            return new WavefrontClient(this);
        }

        private URI buildUri(String server, int port) throws URISyntaxException {
            URI uri = new URI(server);
            if (port <= 0) {
                return uri;
            }
            return new URI(uri.getScheme(), null, uri.getHost(), port, uri.getPath(), uri.getQuery(), uri.getFragment());
        }
    }
}

