/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.http.retry;

import com.webull.openapi.http.retry.RetryOnExceptionCondition;
import com.webull.openapi.http.retry.RetryOnHttpMethodCondition;
import com.webull.openapi.http.retry.RetryOnHttpStatusCondition;
import com.webull.openapi.retry.RetryContext;
import com.webull.openapi.retry.condition.AndMergeRetryCondition;
import com.webull.openapi.retry.condition.MaxRetryTimesCondition;
import com.webull.openapi.retry.condition.OrMergeRetryCondition;
import com.webull.openapi.retry.condition.RetryCondition;
import java.util.ArrayList;

public class DefaultHttpRetryCondition
implements RetryCondition {
    private final OrMergeRetryCondition orMergeRetryCondition;

    public DefaultHttpRetryCondition(int maxRetryTimes) {
        ArrayList<RetryCondition> orMergeRetryConditions = new ArrayList<RetryCondition>();
        orMergeRetryConditions.add(new MaxRetryTimesCondition(maxRetryTimes));
        orMergeRetryConditions.add(new RetryOnHttpMethodCondition());
        ArrayList<RetryCondition> andMergeRetryConditions = new ArrayList<RetryCondition>();
        andMergeRetryConditions.add(new RetryOnExceptionCondition());
        andMergeRetryConditions.add(new RetryOnHttpStatusCondition());
        orMergeRetryConditions.add(new AndMergeRetryCondition(andMergeRetryConditions));
        this.orMergeRetryCondition = new OrMergeRetryCondition(orMergeRetryConditions);
    }

    @Override
    public boolean shouldRetry(RetryContext context) {
        return this.orMergeRetryCondition.shouldRetry(context);
    }
}

