/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.http.retry;

import com.webull.openapi.http.retry.HttpRetryContext;
import com.webull.openapi.logger.Logger;
import com.webull.openapi.logger.LoggerFactory;
import com.webull.openapi.retry.RetryContext;
import com.webull.openapi.retry.condition.RetryCondition;
import java.util.Arrays;

public class RetryOnHttpStatusCondition
implements RetryCondition {
    private static final Logger logger = LoggerFactory.getLogger(RetryOnHttpStatusCondition.class);
    private static final Integer[] DEFAULT_RETRYABLE_HTTP_STATUS_LIST = new Integer[]{500, 502, 503, 504};
    private final Integer[] retryableHttpStatusList;

    public RetryOnHttpStatusCondition() {
        this(DEFAULT_RETRYABLE_HTTP_STATUS_LIST);
    }

    public RetryOnHttpStatusCondition(Integer[] retryableHttpStatusList) {
        this.retryableHttpStatusList = retryableHttpStatusList == null || retryableHttpStatusList.length == 0 ? DEFAULT_RETRYABLE_HTTP_STATUS_LIST : retryableHttpStatusList;
    }

    @Override
    public boolean shouldRetry(RetryContext context) {
        if (!(context instanceof HttpRetryContext)) {
            throw new IllegalArgumentException("Retry context[" + context.getClass().getName() + "] is inappropriate to http retry condition!");
        }
        HttpRetryContext httpCtx = (HttpRetryContext)context;
        int httpStatusCode = httpCtx.getHttpStatusCode();
        if (Arrays.stream(this.retryableHttpStatusList).anyMatch(r -> r == httpStatusCode)) {
            logger.debug("Retryable HTTP error occurred. HTTP status code: {}", (Object)httpStatusCode);
            return true;
        }
        return false;
    }
}

