/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.utils;

import com.webull.openapi.execption.ClientException;
import com.webull.openapi.utils.CollectionUtils;
import com.webull.openapi.utils.StringUtils;
import java.util.Collection;
import java.util.List;

public final class Assert {
    private Assert() {
    }

    public static void notNull(String name, Object source) {
        if (source == null) {
            throw new ClientException("InvalidParameter", name + " is null");
        }
    }

    public static void notNull(List<String> names, Object ... sources) {
        if (sources == null || sources.length == 0) {
            throw new ClientException("InvalidParameter", "sources is empty");
        }
        if (CollectionUtils.isEmpty(names) || names.size() != sources.length) {
            throw new ClientException("InvalidParameter", "names is empty");
        }
        for (int i = 0; i < sources.length; ++i) {
            Object val = sources[i];
            if (val != null) continue;
            throw new ClientException("InvalidParameter", names.get(i) + " is null");
        }
    }

    public static void notBlank(List<String> names, String ... sources) {
        if (sources == null || sources.length == 0) {
            throw new ClientException("InvalidParameter", "sources is empty");
        }
        if (CollectionUtils.isEmpty(names) || names.size() != sources.length) {
            throw new ClientException("InvalidParameter", "names is empty");
        }
        for (int i = 0; i < sources.length; ++i) {
            String val = sources[i];
            if (!StringUtils.isBlank(val)) continue;
            throw new ClientException("InvalidParameter", names.get(i) + " is blank");
        }
    }

    public static void notBlank(String name, String source) {
        if (StringUtils.isBlank(source)) {
            throw new ClientException("InvalidParameter", name + " is blank");
        }
    }

    public static void notEmpty(String name, Collection<?> source) {
        if (CollectionUtils.isEmpty(source)) {
            throw new ClientException("InvalidParameter", name + " is empty");
        }
    }

    public static void nonnegative(String name, int source) {
        if (source < 0) {
            throw new ClientException("InvalidParameter", name + " is negative");
        }
    }

    public static void nonnegative(String name, long source) {
        if (source < 0L) {
            throw new ClientException("InvalidParameter", name + " is negative");
        }
    }

    public static void inRange(String name, int val, int min, int max) {
        if (min > max) {
            throw new ClientException("InvalidParameter", "min greater than max");
        }
        if (val < min || val > max) {
            throw new ClientException("InvalidParameter", name + " not in range");
        }
    }
}

