/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.http;

import com.webull.openapi.common.ApiModule;
import com.webull.openapi.endpoint.EndpointResolver;
import com.webull.openapi.execption.ClientException;
import com.webull.openapi.http.RuntimeOptions;
import com.webull.openapi.utils.Assert;
import com.webull.openapi.utils.StringUtils;

public class HttpApiConfig {
    private String appKey;
    private String appSecret;
    private String regionId;
    private String endpoint;
    private String userId;
    private Integer port;
    private boolean autoRetry;
    private int maxRetries;
    private RuntimeOptions runtimeOptions;

    private HttpApiConfig() {
    }

    public String getAppKey() {
        return this.appKey;
    }

    public String getAppSecret() {
        return this.appSecret;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public Integer getPort() {
        return this.port;
    }

    public boolean getAutoRetry() {
        return this.autoRetry;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public RuntimeOptions getRuntimeOptions() {
        return this.runtimeOptions;
    }

    public static HttpApiConfigBuilder builder() {
        return new HttpApiConfigBuilder();
    }

    public static final class HttpApiConfigBuilder {
        private String appKey;
        private String appSecret;
        private String regionId;
        private String endpoint;
        private String userId;
        private Integer port;
        private boolean autoRetry = false;
        private int maxRetries = 3;
        private RuntimeOptions runtimeOptions;

        private HttpApiConfigBuilder() {
        }

        public HttpApiConfigBuilder appKey(String appKey) {
            Assert.notBlank("appKey", appKey);
            this.appKey = appKey;
            return this;
        }

        public HttpApiConfigBuilder appSecret(String appSecret) {
            Assert.notBlank("appSecret", appSecret);
            this.appSecret = appSecret;
            return this;
        }

        public HttpApiConfigBuilder regionId(String regionId) {
            Assert.notBlank("regionId", regionId);
            this.regionId = regionId;
            return this;
        }

        public HttpApiConfigBuilder port(int port) {
            Assert.inRange("port", port, 0, 65535);
            this.port = port;
            return this;
        }

        public HttpApiConfigBuilder autoRetry(boolean autoRetry) {
            this.autoRetry = autoRetry;
            return this;
        }

        public HttpApiConfigBuilder maxRetryNum(int maxRetries) {
            Assert.nonnegative("maxRetries", maxRetries);
            this.maxRetries = maxRetries;
            return this;
        }

        public HttpApiConfigBuilder runtimeOptions(RuntimeOptions runtimeOptions) {
            Assert.notNull("runtimeOptions", (Object)runtimeOptions);
            this.runtimeOptions = runtimeOptions;
            return this;
        }

        public HttpApiConfigBuilder endpoint(String endpoint) {
            Assert.notBlank("endpoint", endpoint);
            this.endpoint = endpoint;
            return this;
        }

        public HttpApiConfigBuilder userId(String userId) {
            Assert.notBlank("userId", userId);
            this.userId = userId;
            return this;
        }

        public HttpApiConfig build() {
            HttpApiConfig config = new HttpApiConfig();
            config.appKey = this.appKey;
            config.appSecret = this.appSecret;
            config.regionId = this.regionId;
            if (StringUtils.isBlank(this.endpoint)) {
                Assert.notBlank("regionId", this.regionId);
                EndpointResolver resolver = EndpointResolver.getDefault();
                config.endpoint = resolver.resolve(config.regionId, ApiModule.of("API")).orElseThrow(() -> new ClientException("EndpointResolvingError", "Unknown region"));
            } else {
                config.endpoint = this.endpoint;
            }
            config.port = this.port;
            config.autoRetry = this.autoRetry;
            config.maxRetries = this.maxRetries;
            config.runtimeOptions = this.runtimeOptions != null ? this.runtimeOptions : new RuntimeOptions();
            return config;
        }
    }
}

