/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.http;

import com.google.gson.reflect.TypeToken;
import com.webull.openapi.execption.ClientException;
import com.webull.openapi.http.exception.HttpServerException;
import com.webull.openapi.logger.Logger;
import com.webull.openapi.logger.LoggerFactory;
import com.webull.openapi.serialize.JsonSerializer;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Response;

public class HttpResponse
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(HttpResponse.class);
    private HttpServerException exception;
    private final Response response;
    private final int statusCode;
    private final String statusMessage;
    private final String requestId;
    private final HashMap<String, String> headers = new HashMap();
    private final InputStream body;

    public HttpResponse(Response response) {
        this.response = response;
        this.statusCode = response.code();
        this.statusMessage = response.message();
        this.body = response.body() != null ? response.body().byteStream() : null;
        Map resultHeaders = response.headers().toMultimap();
        for (Map.Entry entry : resultHeaders.entrySet()) {
            this.headers.put((String)entry.getKey(), String.join((CharSequence)";", (Iterable)entry.getValue()));
        }
        this.requestId = this.headers.get("x-request-id");
        if (this.statusCode < 200 || this.statusCode >= 300) {
            String responseBody = this.getResponseBody();
            Map responseMap = new HashMap();
            try {
                responseMap = (Map)JsonSerializer.fromJson(responseBody, new TypeToken<Map<String, String>>(){}.getType());
            }
            catch (Exception e) {
                logger.warn("Failed to parse response as json format, response:{}, requestId:{}", responseBody, this.requestId);
            }
            String errorCode = responseMap.getOrDefault("error_code", "UnknownServerError");
            String message = responseMap.getOrDefault("message", "");
            this.exception = new HttpServerException(errorCode, message, this.statusCode, this.requestId);
        }
    }

    public boolean isSuccess() {
        return this.getException() == null;
    }

    public HttpServerException getException() {
        return this.exception;
    }

    public InputStream getResponse() {
        return this.body;
    }

    public String getResponseBody() {
        if (this.body == null) {
            return String.format("{\"message\":\"%s\"}", this.statusMessage);
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] buff = new byte[4096];
        try {
            int read;
            while ((read = this.body.read(buff)) != -1) {
                os.write(buff, 0, read);
            }
        }
        catch (Exception e) {
            throw new ClientException(e.getMessage(), e);
        }
        return os.toString();
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public void close() {
        this.response.close();
    }
}

