/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.auth.signer;

import com.webull.openapi.auth.signer.HmacSHA1Signer;
import com.webull.openapi.auth.signer.SHA256withRSASigner;
import com.webull.openapi.auth.signer.SignAlgorithm;
import com.webull.openapi.auth.signer.Signer;
import com.webull.openapi.execption.ClientException;
import java.util.EnumMap;
import java.util.Map;

public class SignerFactory {
    private static final SignerFactory INSTANCE = new SignerFactory();
    private final Map<SignAlgorithm, Signer> signerAlgorithmMap = new EnumMap<SignAlgorithm, Signer>(SignAlgorithm.class);

    private SignerFactory() {
        this.signerAlgorithmMap.put(SignAlgorithm.HMAC_SHA1, new HmacSHA1Signer());
        this.signerAlgorithmMap.put(SignAlgorithm.SHA256_WITH_RSA, new SHA256withRSASigner());
    }

    public static SignerFactory getInstance() {
        return INSTANCE;
    }

    public Signer get(SignAlgorithm signAlgorithm) {
        if (this.signerAlgorithmMap.containsKey((Object)signAlgorithm)) {
            return this.signerAlgorithmMap.get((Object)signAlgorithm);
        }
        throw new ClientException("InvalidParameter", "Unrecognized sign algorithm=" + (Object)((Object)signAlgorithm));
    }
}

