/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.endpoint;

import com.webull.openapi.common.ApiModule;
import com.webull.openapi.endpoint.ChainedEndpointResolver;
import com.webull.openapi.endpoint.PredefineEndpointResolver;
import com.webull.openapi.endpoint.SettableEndpointResolver;
import java.util.ArrayList;
import java.util.Optional;

public interface EndpointResolver {
    public int order();

    public Optional<String> resolve(String var1, ApiModule var2);

    public void addEndpoint(String var1, ApiModule var2, String var3);

    public static EndpointResolver getDefault() {
        return DefaultHolder.defaultResolver;
    }

    public static class DefaultHolder {
        private static final EndpointResolver defaultResolver;

        private DefaultHolder() {
        }

        static {
            ArrayList<EndpointResolver> resolvers = new ArrayList<EndpointResolver>(2);
            resolvers.add(PredefineEndpointResolver.getInstance());
            resolvers.add(SettableEndpointResolver.getInstance());
            defaultResolver = new ChainedEndpointResolver(resolvers);
        }
    }
}

