/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.retry.condition;

import com.webull.openapi.logger.Logger;
import com.webull.openapi.logger.LoggerFactory;
import com.webull.openapi.retry.RetryContext;
import com.webull.openapi.retry.condition.RetryCondition;

public class MaxRetryTimesCondition
implements RetryCondition {
    private static final Logger logger = LoggerFactory.getLogger(MaxRetryTimesCondition.class);
    private final int maxRetries;

    public MaxRetryTimesCondition(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    @Override
    public boolean shouldRetry(RetryContext context) {
        if (context.getRetriesAttempted() < this.maxRetries) {
            return true;
        }
        logger.debug("Reached the maximum number of retry, attempts:{}", (Object)context.getRetriesAttempted());
        return false;
    }
}

