/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.config;

import com.webull.openapi.config.ConfigReader;
import com.webull.openapi.logger.Logger;
import com.webull.openapi.logger.LoggerFactory;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class ProjectReader
implements ConfigReader {
    private static final Logger logger = LoggerFactory.getLogger(ProjectReader.class);
    private static final String PROJECT_PROPERTIES = "project.properties";
    private static final ProjectReader projectReader = new ProjectReader();
    private final Map<String, String> properties = new HashMap<String, String>();

    public static ProjectReader getInstance() {
        return projectReader;
    }

    private ProjectReader() {
        ClassLoader classLoader = ProjectReader.class.getClassLoader();
        try (InputStream is = classLoader.getResourceAsStream(this.getPath());){
            Properties prop = new Properties();
            prop.load(is);
            Enumeration<Object> keys = prop.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String value = prop.getProperty(key);
                this.properties.put(key, value);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
    }

    @Override
    public String getPath() {
        return PROJECT_PROPERTIES;
    }

    @Override
    public Object read(String key) {
        return this.properties.getOrDefault(key, null);
    }

    @Override
    public Object readOrDefault(String key, Object defaultValue) {
        Object o = this.read(key);
        return o == null ? defaultValue : o;
    }
}

