/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.logger;

import com.webull.openapi.logger.FormattingTuple;
import com.webull.openapi.utils.StringUtils;
import java.util.HashSet;
import java.util.Set;

final class MessageFormatter {
    private static final String DELIMITER = "{}";
    private static final char ESCAPE_CHAR = '\\';

    private MessageFormatter() {
    }

    private static Throwable getThrowable(Object[] args) {
        int lastIndex = args.length - 1;
        Object last = args[lastIndex];
        if (last instanceof Throwable) {
            return (Throwable)last;
        }
        return null;
    }

    public static FormattingTuple format(String pattern, Object ... args) {
        if (args == null || args.length == 0) {
            return new FormattingTuple(pattern, null);
        }
        Throwable throwable = MessageFormatter.getThrowable(args);
        if (StringUtils.isBlank(pattern)) {
            return new FormattingTuple(pattern, throwable);
        }
        return MessageFormatter.format(pattern, args, throwable);
    }

    private static FormattingTuple format(String pattern, Object[] args, Throwable throwable) {
        int delimiterIdx = pattern.indexOf(DELIMITER);
        if (delimiterIdx == -1) {
            return new FormattingTuple(pattern, throwable);
        }
        StringBuilder builder = new StringBuilder(pattern.length() + 50);
        int charIdx = 0;
        int argIdx = 0;
        while (argIdx < args.length && (delimiterIdx = pattern.indexOf(DELIMITER, charIdx)) != -1) {
            if (MessageFormatter.isEscapedDelimiter(pattern, delimiterIdx)) {
                if (!MessageFormatter.isDoubleEscaped(pattern, delimiterIdx)) {
                    builder.append(pattern, charIdx, delimiterIdx);
                    charIdx = delimiterIdx + 1;
                    continue;
                }
                builder.append(pattern, charIdx, delimiterIdx - 1);
                MessageFormatter.deeplyAppendParameter(builder, args[argIdx], null);
                charIdx = delimiterIdx + 2;
                ++argIdx;
                continue;
            }
            builder.append(pattern, charIdx, delimiterIdx);
            MessageFormatter.deeplyAppendParameter(builder, args[argIdx], null);
            charIdx = delimiterIdx + 2;
            ++argIdx;
        }
        builder.append(pattern, charIdx, pattern.length());
        return new FormattingTuple(builder.toString(), argIdx <= args.length - 1 ? throwable : null);
    }

    private static boolean isEscapedDelimiter(String pattern, int delimiterIndex) {
        return delimiterIndex > 0 && pattern.charAt(delimiterIndex - 1) == '\\';
    }

    private static boolean isDoubleEscaped(String pattern, int delimiterIndex) {
        return delimiterIndex >= 2 && pattern.charAt(delimiterIndex - 2) == '\\';
    }

    private static void deeplyAppendParameter(StringBuilder builder, Object arg, Set<Object[]> seenSet) {
        if (arg == null) {
            builder.append("null");
            return;
        }
        if (!arg.getClass().isArray()) {
            MessageFormatter.appendObject(builder, arg);
            return;
        }
        builder.append('[');
        if (arg instanceof boolean[]) {
            MessageFormatter.appendBooleanArray(builder, (boolean[])arg);
        } else if (arg instanceof byte[]) {
            MessageFormatter.appendByteArray(builder, (byte[])arg);
        } else if (arg instanceof char[]) {
            MessageFormatter.appendCharArray(builder, (char[])arg);
        } else if (arg instanceof short[]) {
            MessageFormatter.appendShortArray(builder, (short[])arg);
        } else if (arg instanceof int[]) {
            MessageFormatter.appendIntArray(builder, (int[])arg);
        } else if (arg instanceof long[]) {
            MessageFormatter.appendLongArray(builder, (long[])arg);
        } else if (arg instanceof float[]) {
            MessageFormatter.appendFloatArray(builder, (float[])arg);
        } else if (arg instanceof double[]) {
            MessageFormatter.appendDoubleArray(builder, (double[])arg);
        } else {
            MessageFormatter.appendObjectArray(builder, (Object[])arg, seenSet);
        }
        builder.append(']');
    }

    private static void appendObject(StringBuilder builder, Object object) {
        try {
            String objectString = object.toString();
            builder.append(objectString);
        }
        catch (Throwable t) {
            System.err.println("Failed toString() invocation on an object of type [" + object.getClass().getName() + ']');
            t.printStackTrace();
            builder.append("[Failed toString()]");
        }
    }

    private static void appendObjectArray(StringBuilder builder, Object[] args, Set<Object[]> seenSet) {
        if (args.length == 0) {
            return;
        }
        if (seenSet == null) {
            seenSet = new HashSet<Object[]>(args.length);
        }
        if (!seenSet.contains(args)) {
            seenSet.add(args);
            int len = args.length;
            for (int i = 0; i < len - 1; ++i) {
                MessageFormatter.deeplyAppendParameter(builder, args[i], seenSet);
                builder.append(", ");
            }
            MessageFormatter.deeplyAppendParameter(builder, args[len - 1], seenSet);
            seenSet.remove(args);
        } else {
            builder.append("...");
        }
    }

    private static void appendBooleanArray(StringBuilder builder, boolean[] args) {
        int len = args.length;
        for (int i = 0; i < len - 1; ++i) {
            builder.append(args[i]);
            builder.append(", ");
        }
        builder.append(args[len - 1]);
    }

    private static void appendByteArray(StringBuilder builder, byte[] args) {
        int len = args.length;
        for (int i = 0; i < len - 1; ++i) {
            builder.append(args[i]);
            builder.append(", ");
        }
        builder.append(args[len - 1]);
    }

    private static void appendCharArray(StringBuilder builder, char[] args) {
        int len = args.length;
        for (int i = 0; i < len - 1; ++i) {
            builder.append(args[i]);
            builder.append(", ");
        }
        builder.append(args[len - 1]);
    }

    private static void appendShortArray(StringBuilder builder, short[] args) {
        int len = args.length;
        for (int i = 0; i < len - 1; ++i) {
            builder.append(args[i]);
            builder.append(", ");
        }
        builder.append(args[len - 1]);
    }

    private static void appendIntArray(StringBuilder builder, int[] args) {
        int len = args.length;
        for (int i = 0; i < len - 1; ++i) {
            builder.append(args[i]);
            builder.append(", ");
        }
        builder.append(args[len - 1]);
    }

    private static void appendLongArray(StringBuilder builder, long[] args) {
        int len = args.length;
        for (int i = 0; i < len - 1; ++i) {
            builder.append(args[i]);
            builder.append(", ");
        }
        builder.append(args[len - 1]);
    }

    private static void appendFloatArray(StringBuilder builder, float[] args) {
        int len = args.length;
        for (int i = 0; i < len - 1; ++i) {
            builder.append(args[i]);
            builder.append(", ");
        }
        builder.append(args[len - 1]);
    }

    private static void appendDoubleArray(StringBuilder builder, double[] args) {
        int len = args.length;
        for (int i = 0; i < len - 1; ++i) {
            builder.append(args[i]);
            builder.append(", ");
        }
        builder.append(args[len - 1]);
    }
}

