/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.http.retry;

import com.webull.openapi.execption.ClientException;
import com.webull.openapi.execption.ServerException;
import com.webull.openapi.http.common.HttpMethod;
import com.webull.openapi.http.retry.HttpRetryContext;
import com.webull.openapi.retry.RetryContext;
import com.webull.openapi.retry.condition.RetryCondition;

public class RetryOnHttpMethodCondition
implements RetryCondition {
    @Override
    public boolean shouldRetry(RetryContext context) {
        if (!(context instanceof HttpRetryContext)) {
            throw new IllegalArgumentException("Retry context[" + context.getClass().getName() + "] is inappropriate to http retry condition!");
        }
        HttpRetryContext httpCtx = (HttpRetryContext)context;
        Throwable cause = httpCtx.getCause();
        if (cause instanceof ClientException || cause instanceof ServerException) {
            return HttpMethod.GET == httpCtx.getMethod();
        }
        return false;
    }
}

