/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.logger;

import com.webull.openapi.logger.FormattingTuple;
import com.webull.openapi.logger.Logger;
import com.webull.openapi.logger.MessageFormatter;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;

final class Log4JLogger
implements Logger {
    private static final String FQCN = Log4JLogger.class.getName();
    private final org.apache.log4j.Logger logger;
    private boolean supportTrace = true;

    public Log4JLogger(org.apache.log4j.Logger logger) {
        this.logger = logger;
        try {
            logger.isTraceEnabled();
        }
        catch (NoSuchMethodError ignored) {
            this.supportTrace = false;
        }
    }

    @Override
    public String name() {
        return this.logger.getName();
    }

    @Override
    public boolean isTraceEnabled() {
        if (this.supportTrace) {
            return this.logger.isTraceEnabled();
        }
        return this.logger.isDebugEnabled();
    }

    @Override
    public void trace(String msg) {
        this.logger.log(FQCN, (Priority)(this.supportTrace ? Level.TRACE : Level.DEBUG), (Object)msg, null);
    }

    @Override
    public void trace(String format, Object arg) {
        if (this.isTraceEnabled()) {
            FormattingTuple tuple = MessageFormatter.format(format, arg);
            this.logger.log(FQCN, (Priority)(this.supportTrace ? Level.TRACE : Level.DEBUG), (Object)tuple.getMessage(), tuple.getThrowable());
        }
    }

    @Override
    public void trace(String format, Object ... args) {
        if (this.isTraceEnabled()) {
            FormattingTuple tuple = MessageFormatter.format(format, args);
            this.logger.log(FQCN, (Priority)(this.supportTrace ? Level.TRACE : Level.DEBUG), (Object)tuple.getMessage(), tuple.getThrowable());
        }
    }

    @Override
    public void trace(String msg, Throwable t) {
        this.logger.log(FQCN, (Priority)(this.supportTrace ? Level.TRACE : Level.DEBUG), (Object)msg, t);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public void debug(String msg) {
        this.logger.log(FQCN, (Priority)Level.DEBUG, (Object)msg, null);
    }

    @Override
    public void debug(String format, Object arg) {
        if (this.logger.isDebugEnabled()) {
            FormattingTuple tuple = MessageFormatter.format(format, arg);
            this.logger.log(FQCN, (Priority)Level.DEBUG, (Object)tuple.getMessage(), tuple.getThrowable());
        }
    }

    @Override
    public void debug(String format, Object ... args) {
        if (this.logger.isDebugEnabled()) {
            FormattingTuple tuple = MessageFormatter.format(format, args);
            this.logger.log(FQCN, (Priority)Level.DEBUG, (Object)tuple.getMessage(), tuple.getThrowable());
        }
    }

    @Override
    public void debug(String msg, Throwable t) {
        this.logger.log(FQCN, (Priority)Level.DEBUG, (Object)msg, t);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public void info(String msg) {
        this.logger.log(FQCN, (Priority)Level.INFO, (Object)msg, null);
    }

    @Override
    public void info(String format, Object arg) {
        if (this.logger.isInfoEnabled()) {
            FormattingTuple tuple = MessageFormatter.format(format, arg);
            this.logger.log(FQCN, (Priority)Level.INFO, (Object)tuple.getMessage(), tuple.getThrowable());
        }
    }

    @Override
    public void info(String format, Object ... argArray) {
        if (this.logger.isInfoEnabled()) {
            FormattingTuple tuple = MessageFormatter.format(format, argArray);
            this.logger.log(FQCN, (Priority)Level.INFO, (Object)tuple.getMessage(), tuple.getThrowable());
        }
    }

    @Override
    public void info(String msg, Throwable t) {
        this.logger.log(FQCN, (Priority)Level.INFO, (Object)msg, t);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isEnabledFor((Priority)Level.WARN);
    }

    @Override
    public void warn(String msg) {
        this.logger.log(FQCN, (Priority)Level.WARN, (Object)msg, null);
    }

    @Override
    public void warn(String format, Object arg) {
        if (this.logger.isEnabledFor((Priority)Level.WARN)) {
            FormattingTuple tuple = MessageFormatter.format(format, arg);
            this.logger.log(FQCN, (Priority)Level.WARN, (Object)tuple.getMessage(), tuple.getThrowable());
        }
    }

    @Override
    public void warn(String format, Object ... argArray) {
        if (this.logger.isEnabledFor((Priority)Level.WARN)) {
            FormattingTuple tuple = MessageFormatter.format(format, argArray);
            this.logger.log(FQCN, (Priority)Level.WARN, (Object)tuple.getMessage(), tuple.getThrowable());
        }
    }

    @Override
    public void warn(String msg, Throwable t) {
        this.logger.log(FQCN, (Priority)Level.WARN, (Object)msg, t);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isEnabledFor((Priority)Level.ERROR);
    }

    @Override
    public void error(String msg) {
        this.logger.log(FQCN, (Priority)Level.ERROR, (Object)msg, null);
    }

    @Override
    public void error(String format, Object arg) {
        if (this.logger.isEnabledFor((Priority)Level.ERROR)) {
            FormattingTuple tuple = MessageFormatter.format(format, arg);
            this.logger.log(FQCN, (Priority)Level.ERROR, (Object)tuple.getMessage(), tuple.getThrowable());
        }
    }

    @Override
    public void error(String format, Object ... argArray) {
        if (this.logger.isEnabledFor((Priority)Level.ERROR)) {
            FormattingTuple tuple = MessageFormatter.format(format, argArray);
            this.logger.log(FQCN, (Priority)Level.ERROR, (Object)tuple.getMessage(), tuple.getThrowable());
        }
    }

    @Override
    public void error(String msg, Throwable t) {
        this.logger.log(FQCN, (Priority)Level.ERROR, (Object)msg, t);
    }
}

