/*
 * Decompiled with CFR 0.152.
 */
package com.webull.openapi.retry.backoff;

import com.webull.openapi.retry.RetryContext;
import com.webull.openapi.retry.backoff.BackoffStrategy;
import com.webull.openapi.retry.backoff.ExponentialBackoffStrategy;
import com.webull.openapi.retry.backoff.JitterExponentialBackoffStrategy;
import java.util.concurrent.TimeUnit;

public class DefaultMixedBackoffStrategy
implements BackoffStrategy {
    private static final long DEFAULT_INITIAL_DELAY_NANOS = TimeUnit.MILLISECONDS.toNanos(100L);
    private static final long DEFAULT_JITTER_INITIAL_DELAY_NANOS = TimeUnit.MILLISECONDS.toNanos(500L);
    private static final long DEFAULT_MAX_DELAY_NANOS = TimeUnit.SECONDS.toNanos(20L);
    private final ExponentialBackoffStrategy exponentialBackoffStrategy = new ExponentialBackoffStrategy(DEFAULT_INITIAL_DELAY_NANOS, DEFAULT_MAX_DELAY_NANOS, TimeUnit.NANOSECONDS);
    private final ExponentialBackoffStrategy defaultThrottledBackoffStrategy = new JitterExponentialBackoffStrategy(DEFAULT_JITTER_INITIAL_DELAY_NANOS, DEFAULT_MAX_DELAY_NANOS, TimeUnit.NANOSECONDS);

    @Override
    public long nextRetryDelay(RetryContext context, TimeUnit timeUnit) {
        if (context.throttled()) {
            return this.defaultThrottledBackoffStrategy.nextRetryDelay(context, timeUnit);
        }
        return this.exponentialBackoffStrategy.nextRetryDelay(context, timeUnit);
    }
}

