/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms of the
 * GNU Lesser General Public License as published by the Free Software Foundation; either version
 * 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */

package com.wedeploy.api.sdk;

/**
 * Error 404 errors.
 */
public class Error404<T> extends ErrorBase<T, Error404<T>> {

	public Error404(ErrorData<T> errorData, String message) {
		super(errorData, 404, message, "Not Found");
	}

	public Error404<T> notFound() {return notFound(null); }

	public Error404<T> notFound(String message) {
		return error(
			"notFound", message,
			"The requested operation failed because a resource associated" +
				" with the request could not be found."
		);
	}

	public Error404<T> unsupportedProtocol() {
		return unsupportedProtocol(null);
	}

	public Error404<T> unsupportedProtocol(String message) {
		return error(
			"unsupportedProtocol", message,
			"The protocol used in the request is not supported."
		);
	}

}
