package com.wedeploy.api.sdk;

/**
 * Error 503 errors.
 */
public class Error503<T> extends ErrorBase<T, Error503<T>> {

	public Error503(ErrorData<T> errorData, String message) {
		super(errorData, 503, message, "Service unavailable");
	}

	public Error503<T> serviceUnavailable() {
		return serviceUnavailable(null);
	}

	public Error503<T> serviceUnavailable(String message) {
		return error(
			"serviceUnavailable", message,
			"The server is currently unavailable (because it is overloaded or down for maintenance)."
		);
	}

}
