/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms of the
 * GNU Lesser General Public License as published by the Free Software Foundation; either version
 * 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */

package com.wedeploy.api.sdk;

/**
 * Simple map.
 */
public interface SharedData {

	/**
	 * Get a value from the map.
	 */
	<T> T get(String key);

	/**
	 * Get a value from the map with given type.
	 */
	<T> T get(String key, Class<T> type);

	/**
	 * Put a value in the map.
	 */
	void put(String key, Object value);

	/**
	 * Put the entry only if there is no entry with the key already present.
	 */
	void putIfAbsent(String key, Object value);

	/**
	 * Remove a value from the map.
	 */
	<T> T remove(String key);

	/**
	 * Remove a value from the map, returning stored value with given type.
	 */
	<T> T remove(String key, Class<T> type);

	/**
	 * Clear all entries in the map
	 */
	void clear();

	/**
	 * Provide the number of entries in the map
	 */
	int size();

}