/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * <p>
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * <p>
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * <p>
 * 3. Neither the name of Liferay, Inc. nor the names of its contributors may
 * be used to endorse or promote products derived from this software without
 * specific prior written permission.
 * <p>
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

package com.wedeploy.api.sdk;

import com.wedeploy.api.WeDeployException;

import java.net.URI;
import java.net.URISyntaxException;

/**
 * {@link Request} implementation.
 */
public class RequestImpl extends Base<Request> implements Request {

	public RequestImpl(String url) {
		this.url(url);
	}

	@Override
	public Auth auth() {
		throw new UnsupportedOperationException();
	}

	@Override
	public String baseUrl() {
		return baseUrl;
	}

	@Override
	public FileUpload[] fileUploads() {
		return fileUploads;
	}

	@Override
	public Object form(String name) {
		return form.get(name);
	}

	@Override
	public Request form(String name, Object value) {
		form.set(name, value);
		return this;
	}

	@Override
	public MultiMap<Object> forms() {
		return form;
	}

	/**
	 * Sets the file uploads.
	 */
	Request fileUploads(FileUpload... fileUploads) {
		this.fileUploads = fileUploads;
		return this;
	}

	@Override
	public String method() {
		return method;
	}

	@Override
	public Request method(String method) {
		this.method = method;
		return this;
	}

	@Override
	public void next() {
		throw new UnsupportedOperationException();
	}

	@Override
	public void next(OnResponseEndCallback onResponseEnd) {
		throw new UnsupportedOperationException();
	}

	/**
	 * Gets the parameter value.
	 */
	public String param(String name) {
		return this.params().get(name);
	}

	@Override
	public Request param(String name, String value) {
		params.set(name, value);
		return this;
	}

	@Override
	public MultiMap<String> params() {
		return params;
	}

	@Override
	public String path() {
		return path;
	}

	@Override
	public String query() {
		return query;
	}

	@Override
	public Response response() {
		return response;
	}

	@Override
	public void response(Response response) {
		this.response = response;
	}

	@Override
	public Session session() {
		throw new UnsupportedOperationException();
	}

	@Override
	public String url() {
		return url;
	}

	@Override
	public MultiMap<Object> values() {
		throw new UnsupportedOperationException();
	}

	@Override
	public <T> T values(Class<T> type) {
		throw new UnsupportedOperationException();
	}

	protected String baseUrl;
	protected FileUpload[] fileUploads;
	protected MultiMap<Object> form = MultiMap.newMultiMap();
	protected String method;
	protected MultiMap<String> params = MultiMap.newMultiMap();
	protected String path;
	protected String query;
	protected Response response;
	protected String url;

	private void url(String url) {
		this.url = url;

		// clear attributes

		this.baseUrl = null;
		this.path = null;
		this.query = null;

		if (url == null) {
			return;
		}

		try {
			if (url.charAt(0) == '/') {
				int separator = url.indexOf('?');

				if (separator == -1) {
					path = url;
				} else {
					path = url.substring(0, separator);
					query = url.substring(separator + 1, url.length());
				}
			} else {
				if (!url.contains("://")) {
					url = "http://" + url;
				}

				URI parsedUrl = new URI(url);

				if (parsedUrl.getHost() != null) {
					baseUrl = parsedUrl.getScheme() + "://";

					baseUrl += parsedUrl.getHost();

					if (parsedUrl.getPort() != -1) {
						baseUrl += ":" + parsedUrl.getPort();
					}

					path = parsedUrl.getRawPath();
					query = parsedUrl.getRawQuery();
				}
			}
		} catch (URISyntaxException urise) {
			throw new WeDeployException("Invalid URL: " + url, urise);
		}
	}

}
