/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * <p>
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * <p>
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * <p>
 * 3. Neither the name of Liferay, Inc. nor the names of its contributors may
 * be used to endorse or promote products derived from this software without
 * specific prior written permission.
 * <p>
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

package com.wedeploy.api.sdk;

/**
 * DataSnapshot.
 */
public interface DataSnapshot {

	/**
	 * Navigates in key path, e.g. "/foo" -> data.child("1") -> /foo/1.
	 */
	public DataSnapshot child(String... names);

	/**
	 * Navigates to the document path,
	 * e.g. "/foo/1/a" -> $data.document() -> /foo/1.
	 */
	public DataSnapshot document();

	/**
	 * Checks if the data exists.
	 */
	public boolean exists();

	/**
	 * Navigates to parent key path, e.g. "/foo/1/child" -> data.parent() -> /foo/1.
	 */
	public DataSnapshot parent();

	/**
	 * Retrieves a snapshot of the existing data.
	 */
	public <T> T storedValue();

	/**
	 * Retrieves a snapshot of the existing data and parses into the target type.
	 *
	 * @see #storedValue()
	 */
	public <T> T storedValue(Class<T> type);

	/**
	 * Checks if the data does not exists in the collection.
	 */
	public boolean unique();

	/**
	 * Parses the body depending on content-type. If content-type is NOT set,
	 * it will use assume the "plain/text" content type.
	 * Returns {@link Request#bodyValue()} if data not committed,
	 * {@link Response#bodyValue()} otherwise.
	 * If body is not set, returns <code>null</code>.
	 * If body can not be parsed, throws an Exception.
	 */
	public <T> T value();

	/**
	 * Parses the body depending on content-type into the target type.
	 *
	 * @see #value()
	 */
	public <T> T value(Class<T> type);

}
