/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * <p>
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * <p>
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * <p>
 * 3. Neither the name of Liferay, Inc. nor the names of its contributors may
 * be used to endorse or promote products derived from this software without
 * specific prior written permission.
 * <p>
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

package com.wedeploy.api.sdk;

abstract class ErrorBase<T, E extends ErrorBase> implements Error<T> {

	protected ErrorBase(
		ErrorData<T> errorData, int status, String message,
		String defaultMessage) {

		this.errorData = errorData;
		this.errorData.set(status, message, defaultMessage);
	}

	@Override
	public ErrorData<T> data() {
		return errorData;
	}

	@Override
	public final T into(T response) {
		return errorData.into(response);
	}

	@Override
	public final E error(String reason, String message) {
		errorData.add(reason, message);
		return (E) this;
	}

	@Override
	public final E header(String name, String value) {
		errorData.header(name, value);
		return (E) this;
	}

	protected final E error(String reason, String message, String defaultMessage) {
		error(reason, message, defaultMessage, null);
		return (E) this;
	}

	protected final E error(String reason, String message, String defaultMessage, Throwable throwable) {
		if (message == null) {
			message = defaultMessage;
		}
		errorData.add(reason, message, throwable);
		return (E) this;
	}

	private final ErrorData<T> errorData;

}
