/*
 * Decompiled with CFR 0.152.
 */
package com.wedeploy.api;

import com.wedeploy.api.WeDeployException;
import com.wedeploy.api.query.Aggregation;
import com.wedeploy.api.query.Filter;
import com.wedeploy.api.query.Query;
import com.wedeploy.api.realtime.RealTime;
import com.wedeploy.api.sdk.Auth;
import com.wedeploy.api.sdk.ContentType;
import com.wedeploy.api.sdk.Cookie;
import com.wedeploy.api.sdk.MultiMap;
import com.wedeploy.api.sdk.Request;
import com.wedeploy.api.sdk.RequestImpl;
import com.wedeploy.api.sdk.Response;
import com.wedeploy.api.serializer.Serializer;
import com.wedeploy.api.transport.impl.DefaultTransport;
import com.wedeploy.api.transport.impl.Transport;
import com.wedeploy.api.util.Util;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class WeDeploy {
    public static String MASTER_TOKEN;
    public static final String METHOD_DELETE = "DELETE";
    public static final String METHOD_GET = "GET";
    public static final String METHOD_PATCH = "PATCH";
    public static final String METHOD_POST = "POST";
    public static final String METHOD_PUT = "PUT";
    protected Auth auth;
    protected final List<Cookie> cookies = new ArrayList<Cookie>();
    protected Transport currentTransport;
    protected final MultiMap<Object> forms = MultiMap.newMultiMap();
    protected final MultiMap<String> headers = MultiMap.newMultiMap();
    protected final MultiMap<String> params = MultiMap.newMultiMap();
    protected Query.Builder query;
    protected final String url;

    public static WeDeploy url(String url) {
        return new WeDeploy(url);
    }

    public WeDeploy(String url) {
        this.url = url;
    }

    public WeDeploy aggregate(Aggregation aggregation) {
        this.getOrCreateQuery().aggregate(aggregation);
        return this;
    }

    public WeDeploy aggregate(String name, String field, String operator) {
        return this.aggregate(Aggregation.of(name, field, operator));
    }

    public WeDeploy auth(Auth auth) {
        this.auth = auth;
        return this;
    }

    public WeDeploy auth(String token) {
        this.auth(Auth.create(token));
        return this;
    }

    public WeDeploy auth(String username, String password) {
        this.auth(Auth.create(username, password));
        return this;
    }

    public WeDeploy contentType(ContentType contentType) {
        this.header("Content-Type", contentType.toString());
        return this;
    }

    public WeDeploy cookie(Cookie cookie) {
        this.cookies.add(cookie);
        return this;
    }

    public WeDeploy count() {
        this.getOrCreateQuery().count();
        return this;
    }

    public Response delete() {
        return this.delete(null);
    }

    public Response delete(Object body) {
        return this.send(METHOD_DELETE, body);
    }

    public Response delete(String body) {
        return this.send(METHOD_DELETE, body);
    }

    public CompletableFuture<Response> deleteAsync() {
        return this.deleteAsync(null);
    }

    public CompletableFuture<Response> deleteAsync(Object body) {
        return this.sendAsync(METHOD_DELETE, body);
    }

    public CompletableFuture<Response> deleteAsync(String body) {
        return this.sendAsync(METHOD_DELETE, body);
    }

    public WeDeploy filter(Filter filter) {
        this.getOrCreateQuery().filter(filter);
        return this;
    }

    public WeDeploy filter(String field, Object value) {
        return this.filter(Filter.field(field, value));
    }

    public WeDeploy filter(String field, String operator, Object value) {
        return this.filter(Filter.field(field, operator, value));
    }

    public Object form(String name) {
        return this.forms.get(name);
    }

    public WeDeploy form(String name, Object value) {
        this.forms.set(name, value);
        return this;
    }

    public MultiMap<Object> forms() {
        return this.forms;
    }

    public Response get() {
        return this.send(METHOD_GET, null);
    }

    public Response get(Object body) {
        return this.send(METHOD_GET, body);
    }

    public Response get(String body) {
        return this.send(METHOD_GET, body);
    }

    public CompletableFuture<Response> getAsync() {
        return this.sendAsync(METHOD_GET, null);
    }

    public CompletableFuture<Response> getAsync(Object body) {
        return this.sendAsync(METHOD_GET, body);
    }

    public CompletableFuture<Response> getAsync(String body) {
        return this.sendAsync(METHOD_GET, body);
    }

    public WeDeploy header(String name, String value) {
        this.headers.set(name, value);
        return this;
    }

    public WeDeploy highlight(String field) {
        this.getOrCreateQuery().highlight(field);
        return this;
    }

    public WeDeploy limit(int limit) {
        this.getOrCreateQuery().limit(limit);
        return this;
    }

    public WeDeploy offset(int offset) {
        this.getOrCreateQuery().offset(offset);
        return this;
    }

    public WeDeploy param(String name, Object value) {
        String valueString = null;
        if (value != null) {
            Serializer serializer = Serializer.get(ContentType.JSON);
            valueString = serializer.serialize(value);
        } else {
            valueString = null;
        }
        this.params.set(name, valueString);
        return this;
    }

    public WeDeploy param(String name, String value) {
        this.params.set(name, value);
        return this;
    }

    public Response patch() {
        return this.patch(null);
    }

    public Response patch(Object body) {
        return this.send(METHOD_PATCH, body);
    }

    public Response patch(String body) {
        return this.send(METHOD_PATCH, body);
    }

    public CompletableFuture<Response> patchAsync() {
        return this.patchAsync(null);
    }

    public CompletableFuture<Response> patchAsync(Object body) {
        return this.sendAsync(METHOD_PATCH, body);
    }

    public CompletableFuture<Response> patchAsync(String body) {
        return this.sendAsync(METHOD_PATCH, body);
    }

    public WeDeploy path(String path) {
        return new WeDeploy(this.url, path).use(this.currentTransport).auth(this.auth);
    }

    public WeDeploy path(String ... paths) {
        WeDeploy instance = this;
        for (String path : paths) {
            instance = instance.path(path);
        }
        return instance;
    }

    public Response post() {
        return this.post(null);
    }

    public Response post(Object body) {
        return this.send(METHOD_POST, body);
    }

    public Response post(String body) {
        return this.send(METHOD_POST, body);
    }

    public CompletableFuture<Response> postAsync() {
        return this.postAsync(null);
    }

    public CompletableFuture<Response> postAsync(Object body) {
        return this.sendAsync(METHOD_POST, body);
    }

    public CompletableFuture<Response> postAsync(String body) {
        return this.sendAsync(METHOD_POST, body);
    }

    public Response put() {
        return this.put(null);
    }

    public Response put(Object body) {
        return this.send(METHOD_PUT, body);
    }

    public Response put(String body) {
        return this.send(METHOD_PUT, body);
    }

    public CompletableFuture<Response> putAsync() {
        return this.putAsync(null);
    }

    public CompletableFuture<Response> putAsync(Object body) {
        return this.sendAsync(METHOD_PUT, body);
    }

    public CompletableFuture<Response> putAsync(String body) {
        return this.sendAsync(METHOD_PUT, body);
    }

    public WeDeploy search(Filter filter) {
        this.getOrCreateQuery().search(filter);
        return this;
    }

    public WeDeploy search(String text) {
        return this.search(Filter.match(text));
    }

    public WeDeploy search(String field, String text) {
        return this.search(Filter.match(field, text));
    }

    public WeDeploy search(String field, String operator, Object value) {
        return this.search(Filter.field(field, operator, value));
    }

    public WeDeploy sort(String field) {
        return this.sort(field, "asc");
    }

    public WeDeploy sort(String field, String direction) {
        this.getOrCreateQuery().sort(field, direction);
        return this;
    }

    public String url() {
        return this.url;
    }

    public WeDeploy use(Transport transport) {
        this.currentTransport = transport;
        return this;
    }

    public RealTime watch() {
        return this.watch(null);
    }

    public RealTime watch(Object body) {
        return this.watch(this.resolveBodyString(body), null);
    }

    public RealTime watch(Object body, Map<String, Object> options) {
        return this.watch(this.resolveBodyString(body), options);
    }

    public RealTime watch(String body) {
        return this.watch(body, null);
    }

    public RealTime watch(String body, Map<String, Object> options) {
        RequestImpl clientRequest = this.resolveRequest(METHOD_GET, body, true);
        String query = Util.addParametersToQueryString(clientRequest.query(), clientRequest.params());
        String clientUrl = Util.joinPathAndQuery(clientRequest.path(), query);
        HashMap<String, String> optionsQuery = new HashMap<String, String>();
        optionsQuery.put("url", clientUrl);
        if (options == null) {
            options = new HashMap<String, Object>();
        }
        options.putIfAbsent("forceNew", true);
        options.putIfAbsent("path", clientRequest.path());
        options.putIfAbsent("query", optionsQuery);
        try {
            return RealTime.io(clientRequest.baseUrl(), options);
        }
        catch (NullPointerException npe) {
            throw new WeDeployException("Socket.io client not loaded");
        }
        catch (Exception e) {
            throw new WeDeployException(e.getMessage());
        }
    }

    protected WeDeploy(String baseUrl, String url) {
        this.url = Util.joinPaths(baseUrl, url);
    }

    protected void resolveAuthentication(Request request) {
        if (this.auth.hasEmail() && this.auth.hasPassword()) {
            String credentials = this.auth.email() + ":" + this.auth.password();
            request.header("Authorization", "Basic " + Base64.getEncoder().encodeToString(credentials.getBytes()));
        }
        if (this.auth.hasToken()) {
            request.header("Authorization", "Bearer " + this.auth.token());
        }
    }

    protected String resolveBodyString(Object body) {
        Serializer serializer;
        if (body == null) {
            return null;
        }
        String existingContentType = this.headers.get("Content-Type");
        if (existingContentType == null) {
            this.headers.set("Content-Type", ContentType.JSON.toString());
            serializer = Serializer.get(ContentType.JSON);
        } else {
            serializer = Serializer.get(new ContentType(existingContentType));
        }
        Package pkg = body.getClass().getPackage();
        if (pkg != null) {
            switch (pkg.getName()) {
                case "com.wedeploy.api.query": {
                    return body.toString();
                }
            }
        }
        return serializer.serialize(body);
    }

    protected RequestImpl resolveRequest(String methodName, String body) {
        return this.resolveRequest(methodName, body, false);
    }

    protected RequestImpl resolveRequest(String methodName, String body, boolean convertBody) {
        RequestImpl request = new RequestImpl(this.url());
        request.method(methodName);
        request.body(body);
        if (request.body() == null && this.query != null) {
            request.body(this.resolveBodyString(this.query));
            this.query = null;
        }
        if (this.auth != null) {
            this.resolveAuthentication(request);
        }
        this.cookies.forEach(request::cookie);
        this.headers.forEach(entry -> request.headers().add((String)entry.getKey(), (String)entry.getValue()));
        this.params.forEach(entry -> request.params().add((String)entry.getKey(), (String)entry.getValue()));
        this.forms.forEach(entry -> request.forms().add((String)entry.getKey(), entry.getValue()));
        if (convertBody) {
            this.convertBodyToParams(request);
            request.body((byte[])null);
        }
        return request;
    }

    protected Transport resolveTransport() {
        if (this.currentTransport == null) {
            this.currentTransport = DefaultTransport.defaultTransport();
        }
        if (this.currentTransport == null) {
            throw new WeDeployException("Transport not specified!");
        }
        return this.currentTransport;
    }

    protected Response send(String methodName, Object body) {
        String bodyJson = this.resolveBodyString(body);
        return this.send(methodName, bodyJson);
    }

    protected Response send(String methodName, String body) {
        Transport transport = this.resolveTransport();
        RequestImpl request = this.resolveRequest(methodName, body);
        return transport.send(request);
    }

    protected CompletableFuture<Response> sendAsync(String methodName, Object body) {
        String bodyJson = this.resolveBodyString(body);
        return this.sendAsync(methodName, bodyJson);
    }

    protected CompletableFuture<Response> sendAsync(String methodName, String body) {
        Transport transport = this.resolveTransport();
        RequestImpl request = this.resolveRequest(methodName, body);
        return transport.sendAsync(request);
    }

    private void convertBodyToParams(Request request) {
        ContentType contentType = ContentType.JSON;
        String existingContentType = request.header("Content-Type");
        if (existingContentType != null) {
            contentType = new ContentType(existingContentType);
        }
        Serializer serializer = Serializer.get(contentType);
        request.forms().forEach(entry -> request.param((String)entry.getKey(), serializer.serialize(entry.getValue())));
        try {
            Map bodyJson = (Map)request.bodyValue();
            bodyJson.forEach((name, value) -> request.param((String)name, serializer.serialize(value)));
        }
        catch (ClassCastException | NullPointerException runtimeException) {
            // empty catch block
        }
    }

    private Query.Builder getOrCreateQuery() {
        if (this.query == null) {
            this.query = Query.builder();
        }
        return this.query;
    }
}

