/*
 * Decompiled with CFR 0.152.
 */
package com.wedeploy.api.sdk;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;

public abstract class ErrorData<T> {
    private final Map<String, String> headers = new HashMap<String, String>();
    private int statusCode;
    private String statusMessage;
    private final LinkedList<String[]> subErrors = new LinkedList();

    public String errorBody() {
        StringBuilder errorBody = new StringBuilder();
        errorBody.append("{\n\t\"code\": ");
        errorBody.append(this.statusCode);
        errorBody.append(",\n");
        errorBody.append("\t\"message\": \"");
        errorBody.append(this.encodeString(this.statusMessage));
        errorBody.append("\"");
        if (!this.subErrors.isEmpty()) {
            errorBody.append(",\n");
            errorBody.append("\t\"errors\": [\n");
            for (int i = 0; i < this.subErrors.size(); ++i) {
                String[] subError = this.subErrors.get(i);
                if (i != 0) {
                    errorBody.append(",\n");
                }
                errorBody.append("\t\t{\n");
                errorBody.append("\t\t\t\"reason\": \"");
                errorBody.append(this.encodeString(subError[0]));
                errorBody.append("\",\n");
                errorBody.append("\t\t\t\"message\": \"");
                errorBody.append(this.encodeString(subError[1]));
                errorBody.append("\"\n");
                errorBody.append("\t\t}");
            }
            errorBody.append("\n\t]\n");
        } else {
            errorBody.append("\n");
        }
        errorBody.append("}");
        return errorBody.toString();
    }

    public void headers(BiConsumer<String, String> consumer) {
        this.headers.forEach(consumer);
    }

    public int statusCode() {
        return this.statusCode;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    protected void add(String reason, String message) {
        this.subErrors.add(new String[]{reason, message});
    }

    protected List<String[]> getSubErrors() {
        return this.subErrors;
    }

    protected void header(String name, String value) {
        this.headers.put(name, value);
    }

    protected abstract T into(T var1);

    protected void set(int statusCode, String statusMessage, String defaultMessage) {
        this.statusCode = statusCode;
        if (statusMessage == null) {
            statusMessage = defaultMessage;
        }
        this.statusMessage = statusMessage;
    }

    private String encodeString(String value) {
        StringBuilder sb = new StringBuilder();
        int len = value.length();
        block10: for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\"': {
                    sb.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block10;
                }
                case '/': {
                    sb.append("\\/");
                    continue block10;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block10;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block10;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block10;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block10;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block10;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }
}

