/*
 * Decompiled with CFR 0.152.
 */
package com.wedeploy.api.serializer;

import com.wedeploy.api.serializer.Engines;
import com.wedeploy.api.serializer.Parser;
import com.wedeploy.api.serializer.Serializer;
import com.wedeploy.api.serializer.SerializerException;
import java.util.HashMap;
import java.util.Map;

public class SerializerEngine {
    private static final SerializerEngine instance = new SerializerEngine();
    private Engines defaultEngines;
    private Map<String, Engines> enginesMap = new HashMap<String, Engines>();

    public static SerializerEngine instance() {
        return instance;
    }

    public Parser parser() {
        return this.defaultEngines().getParser();
    }

    public Parser parser(String contentType) {
        Engines engines = this.lookupEngines(contentType);
        return engines.getParser();
    }

    public void registerEngines(String serializerType, Engines engines, boolean isDefault) {
        this.enginesMap.put(serializerType, engines);
        if (isDefault) {
            this.defaultEngines = engines;
        }
    }

    public Serializer serializer() {
        return this.defaultEngines().getSerializer();
    }

    public Serializer serializer(String contentType) {
        Engines engines = this.lookupEngines(contentType);
        return engines.getSerializer();
    }

    protected SerializerEngine() {
    }

    protected void clearEngines() {
        this.defaultEngines = null;
        this.enginesMap.clear();
    }

    protected Engines defaultEngines() {
        if (this.defaultEngines == null) {
            throw new SerializerException("Default content type is not set.");
        }
        return this.defaultEngines;
    }

    protected Engines lookupEngines(String contentType) {
        Engines engines = this.enginesMap.get(contentType);
        if (engines == null) {
            throw new SerializerException("Engine for content type not found: " + contentType);
        }
        return engines;
    }
}

