/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.sessionize.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.UUID;
import org.openapitools.jackson.nullable.JsonNullable;
import software.xdev.sessionize.model.Link;
import software.xdev.sessionize.model.QuestionAnswerFull;
import software.xdev.sessionize.model.SessionMinimal;

@JsonPropertyOrder(value={"id", "firstName", "lastName", "bio", "tagLine", "profilePicture", "isTopSpeaker", "links", "fullName", "sessions", "questionAnswers"})
public class Speaker {
    public static final String JSON_PROPERTY_ID = "id";
    private UUID id;
    public static final String JSON_PROPERTY_FIRST_NAME = "firstName";
    private String firstName;
    public static final String JSON_PROPERTY_LAST_NAME = "lastName";
    private String lastName;
    public static final String JSON_PROPERTY_BIO = "bio";
    private JsonNullable<String> bio = JsonNullable.undefined();
    public static final String JSON_PROPERTY_TAG_LINE = "tagLine";
    private String tagLine;
    public static final String JSON_PROPERTY_PROFILE_PICTURE = "profilePicture";
    private JsonNullable<URI> profilePicture = JsonNullable.undefined();
    public static final String JSON_PROPERTY_IS_TOP_SPEAKER = "isTopSpeaker";
    private Boolean isTopSpeaker;
    public static final String JSON_PROPERTY_LINKS = "links";
    private List<Link> links = new ArrayList<Link>();
    public static final String JSON_PROPERTY_FULL_NAME = "fullName";
    private String fullName;
    public static final String JSON_PROPERTY_SESSIONS = "sessions";
    private List<SessionMinimal> sessions = new ArrayList<SessionMinimal>();
    public static final String JSON_PROPERTY_QUESTION_ANSWERS = "questionAnswers";
    private List<QuestionAnswerFull> questionAnswers = new ArrayList<QuestionAnswerFull>();

    public Speaker id(UUID id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setId(UUID id) {
        this.id = id;
    }

    public Speaker firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    @Nonnull
    @JsonProperty(value="firstName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getFirstName() {
        return this.firstName;
    }

    @JsonProperty(value="firstName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public Speaker lastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    @Nonnull
    @JsonProperty(value="lastName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getLastName() {
        return this.lastName;
    }

    @JsonProperty(value="lastName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public Speaker bio(String bio) {
        this.bio = JsonNullable.of((Object)bio);
        return this;
    }

    @Nullable
    @JsonIgnore
    public String getBio() {
        return (String)this.bio.orElse(null);
    }

    @JsonProperty(value="bio")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getBio_JsonNullable() {
        return this.bio;
    }

    @JsonProperty(value="bio")
    public void setBio_JsonNullable(JsonNullable<String> bio) {
        this.bio = bio;
    }

    public void setBio(String bio) {
        this.bio = JsonNullable.of((Object)bio);
    }

    public Speaker tagLine(String tagLine) {
        this.tagLine = tagLine;
        return this;
    }

    @Nullable
    @JsonProperty(value="tagLine")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getTagLine() {
        return this.tagLine;
    }

    @JsonProperty(value="tagLine")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTagLine(String tagLine) {
        this.tagLine = tagLine;
    }

    public Speaker profilePicture(URI profilePicture) {
        this.profilePicture = JsonNullable.of((Object)profilePicture);
        return this;
    }

    @Nullable
    @JsonIgnore
    public URI getProfilePicture() {
        return (URI)this.profilePicture.orElse(null);
    }

    @JsonProperty(value="profilePicture")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<URI> getProfilePicture_JsonNullable() {
        return this.profilePicture;
    }

    @JsonProperty(value="profilePicture")
    public void setProfilePicture_JsonNullable(JsonNullable<URI> profilePicture) {
        this.profilePicture = profilePicture;
    }

    public void setProfilePicture(URI profilePicture) {
        this.profilePicture = JsonNullable.of((Object)profilePicture);
    }

    public Speaker isTopSpeaker(Boolean isTopSpeaker) {
        this.isTopSpeaker = isTopSpeaker;
        return this;
    }

    @Nonnull
    @JsonProperty(value="isTopSpeaker")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getIsTopSpeaker() {
        return this.isTopSpeaker;
    }

    @JsonProperty(value="isTopSpeaker")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIsTopSpeaker(Boolean isTopSpeaker) {
        this.isTopSpeaker = isTopSpeaker;
    }

    public Speaker links(List<Link> links) {
        this.links = links;
        return this;
    }

    public Speaker addLinksItem(Link linksItem) {
        if (this.links == null) {
            this.links = new ArrayList<Link>();
        }
        this.links.add(linksItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="links")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<Link> getLinks() {
        return this.links;
    }

    @JsonProperty(value="links")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLinks(List<Link> links) {
        this.links = links;
    }

    public Speaker fullName(String fullName) {
        this.fullName = fullName;
        return this;
    }

    @Nonnull
    @JsonProperty(value="fullName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getFullName() {
        return this.fullName;
    }

    @JsonProperty(value="fullName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public Speaker sessions(List<SessionMinimal> sessions) {
        this.sessions = sessions;
        return this;
    }

    public Speaker addSessionsItem(SessionMinimal sessionsItem) {
        if (this.sessions == null) {
            this.sessions = new ArrayList<SessionMinimal>();
        }
        this.sessions.add(sessionsItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="sessions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<SessionMinimal> getSessions() {
        return this.sessions;
    }

    @JsonProperty(value="sessions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSessions(List<SessionMinimal> sessions) {
        this.sessions = sessions;
    }

    public Speaker questionAnswers(List<QuestionAnswerFull> questionAnswers) {
        this.questionAnswers = questionAnswers;
        return this;
    }

    public Speaker addQuestionAnswersItem(QuestionAnswerFull questionAnswersItem) {
        if (this.questionAnswers == null) {
            this.questionAnswers = new ArrayList<QuestionAnswerFull>();
        }
        this.questionAnswers.add(questionAnswersItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="questionAnswers")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<QuestionAnswerFull> getQuestionAnswers() {
        return this.questionAnswers;
    }

    @JsonProperty(value="questionAnswers")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setQuestionAnswers(List<QuestionAnswerFull> questionAnswers) {
        this.questionAnswers = questionAnswers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Speaker speaker = (Speaker)o;
        return Objects.equals(this.id, speaker.id) && Objects.equals(this.firstName, speaker.firstName) && Objects.equals(this.lastName, speaker.lastName) && Speaker.equalsNullable(this.bio, speaker.bio) && Objects.equals(this.tagLine, speaker.tagLine) && Speaker.equalsNullable(this.profilePicture, speaker.profilePicture) && Objects.equals(this.isTopSpeaker, speaker.isTopSpeaker) && Objects.equals(this.links, speaker.links) && Objects.equals(this.fullName, speaker.fullName) && Objects.equals(this.sessions, speaker.sessions) && Objects.equals(this.questionAnswers, speaker.questionAnswers);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.id, this.firstName, this.lastName, Speaker.hashCodeNullable(this.bio), this.tagLine, Speaker.hashCodeNullable(this.profilePicture), this.isTopSpeaker, this.links, this.fullName, this.sessions, this.questionAnswers);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Speaker {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    firstName: ").append(this.toIndentedString(this.firstName)).append("\n");
        sb.append("    lastName: ").append(this.toIndentedString(this.lastName)).append("\n");
        sb.append("    bio: ").append(this.toIndentedString(this.bio)).append("\n");
        sb.append("    tagLine: ").append(this.toIndentedString(this.tagLine)).append("\n");
        sb.append("    profilePicture: ").append(this.toIndentedString(this.profilePicture)).append("\n");
        sb.append("    isTopSpeaker: ").append(this.toIndentedString(this.isTopSpeaker)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    fullName: ").append(this.toIndentedString(this.fullName)).append("\n");
        sb.append("    sessions: ").append(this.toIndentedString(this.sessions)).append("\n");
        sb.append("    questionAnswers: ").append(this.toIndentedString(this.questionAnswers)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        int i;
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getId() != null) {
            try {
                joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getFirstName() != null) {
            try {
                joiner.add(String.format("%sfirstName%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getFirstName()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getLastName() != null) {
            try {
                joiner.add(String.format("%slastName%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getLastName()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getBio() != null) {
            try {
                joiner.add(String.format("%sbio%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getBio()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getTagLine() != null) {
            try {
                joiner.add(String.format("%stagLine%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getTagLine()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getProfilePicture() != null) {
            try {
                joiner.add(String.format("%sprofilePicture%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getProfilePicture()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getIsTopSpeaker() != null) {
            try {
                joiner.add(String.format("%sisTopSpeaker%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getIsTopSpeaker()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getLinks() != null) {
            for (i = 0; i < this.getLinks().size(); ++i) {
                if (this.getLinks().get(i) == null) continue;
                joiner.add(this.getLinks().get(i).toUrlQueryString(String.format("%slinks%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getFullName() != null) {
            try {
                joiner.add(String.format("%sfullName%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getFullName()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getSessions() != null) {
            for (i = 0; i < this.getSessions().size(); ++i) {
                if (this.getSessions().get(i) == null) continue;
                joiner.add(this.getSessions().get(i).toUrlQueryString(String.format("%ssessions%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getQuestionAnswers() != null) {
            for (i = 0; i < this.getQuestionAnswers().size(); ++i) {
                if (this.getQuestionAnswers().get(i) == null) continue;
                joiner.add(this.getQuestionAnswers().get(i).toUrlQueryString(String.format("%squestionAnswers%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        return joiner.toString();
    }
}

