/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.zzc;

@SafeParcelable.Class(creator="FeatureCreator")
@KeepForSdk
public class Feature
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<Feature> CREATOR;
    @SafeParcelable.Field(id=1, getter="getName")
    private final String zza;
    @Deprecated
    @SafeParcelable.Field(id=2, getter="getOldVersion")
    private final int zzb;
    @SafeParcelable.Field(id=3, getter="getVersion", defaultValue="-1")
    private final long zzc;

    public final int hashCode() {
        Object[] objectArray = new Object[]{this.getName(), this.getVersion()};
        return Objects.hashCode(objectArray);
    }

    @KeepForSdk
    public long getVersion() {
        long l = this.zzc;
        if (l == -1L) {
            return this.zzb;
        }
        return l;
    }

    @KeepForSdk
    @NonNull
    public String getName() {
        return this.zza;
    }

    @NonNull
    public final String toString() {
        Objects.ToStringHelper toStringHelper = Objects.toStringHelper(this);
        toStringHelper.add("name", this.getName());
        toStringHelper.add("version", this.getVersion());
        return toStringHelper.toString();
    }

    static {
        zzc zzc2;
        CREATOR = zzc2 = new zzc();
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public Feature(@NonNull String name, long version) {
        void var2_2;
        void var1_1;
        this.zza = var1_1;
        this.zzc = var2_2;
        this.zzb = -1;
    }

    @SafeParcelable.Constructor
    public Feature(@SafeParcelable.Param(id=1) @NonNull String string, @SafeParcelable.Param(id=2) int n, @SafeParcelable.Param(id=3) long l) {
        this.zza = string;
        this.zzb = n;
        this.zzc = l;
    }

    @Override
    public final void writeToParcel(@NonNull Parcel parcel, int n) {
        n = SafeParcelWriter.beginObjectHeader(parcel);
        SafeParcelWriter.writeString(parcel, 1, this.getName(), false);
        SafeParcelWriter.writeInt(parcel, 2, this.zzb);
        SafeParcelWriter.writeLong(parcel, 3, this.getVersion());
        SafeParcelWriter.finishObjectHeader(parcel, n);
    }

    public final boolean equals(@Nullable Object object) {
        if (object instanceof Feature) {
            object = (Feature)object;
            return (this.getName() != null && this.getName().equals(((Feature)object).getName()) || this.getName() == null && ((Feature)object).getName() == null) && this.getVersion() == ((Feature)object).getVersion();
        }
        return false;
    }
}

